/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.items;

import bogdan.refueled.config.ServerConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;

public class CanisterItem
extends Item {
    public CanisterItem() {
        super(new Item.Properties().m_41487_(16));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack copy;
        LazyOptional lazyHandler;
        if (ctx.m_43723_() == null) {
            return super.m_6225_(ctx);
        }
        if (ctx.m_43723_().m_6144_() && (lazyHandler = (copy = ctx.m_43722_().m_255036_(1)).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).isPresent()) {
            Fluid blockFluid;
            IFluidHandler blockHandler;
            boolean success;
            IFluidHandlerItem handler = (IFluidHandlerItem)lazyHandler.resolve().get();
            FluidStack stored = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            BlockPos fluidPos = ctx.m_8083_();
            BlockState state = ctx.m_43725_().m_8055_(fluidPos);
            BlockEntity be = ctx.m_43725_().m_7702_(ctx.m_8083_());
            if (be != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER, ctx.m_43719_()).isPresent() && (success = this.handle(handler, blockHandler = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, ctx.m_43719_()).resolve().get()))) {
                if (!ctx.m_43725_().f_46443_) {
                    ctx.m_43725_().m_5594_(null, ctx.m_8083_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 0.15f, 1.0f);
                }
                if (ctx.m_43722_().m_41613_() > 1) {
                    ctx.m_43722_().m_41774_(1);
                    if (!ctx.m_43723_().m_150109_().m_36054_(copy)) {
                        ctx.m_43723_().m_36176_(copy, true);
                    }
                } else {
                    ctx.m_43723_().m_21008_(ctx.m_43724_(), copy);
                }
                return InteractionResult.m_19078_((boolean)ctx.m_43725_().f_46443_);
            }
            if (!state.m_61147_().contains(BlockStateProperties.f_61362_)) {
                fluidPos = new BlockPos(ctx.m_43719_().m_122436_().m_121955_((Vec3i)fluidPos));
                state = ctx.m_43725_().m_8055_(fluidPos);
                if (!state.m_60795_() && !(state.m_60734_() instanceof LiquidBlock)) {
                    return InteractionResult.FAIL;
                }
            }
            Fluid fluid = blockFluid = ctx.m_43725_().m_6425_(fluidPos).m_76170_() ? ctx.m_43725_().m_6425_(fluidPos).m_76152_() : Fluids.f_76191_;
            if (handler.fill(new FluidStack(blockFluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE) >= 1000 && FluidUtil.tryPickUpFluid((ItemStack)copy, (Player)ctx.m_43723_(), (Level)ctx.m_43725_(), (BlockPos)fluidPos, (Direction)ctx.m_43719_()).success) {
                handler.fill(new FluidStack(blockFluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                if (ctx.m_43722_().m_41613_() > 1) {
                    ctx.m_43722_().m_41774_(1);
                    if (!ctx.m_43723_().m_150109_().m_36054_(copy)) {
                        ctx.m_43723_().m_36176_(copy, true);
                    }
                } else {
                    ctx.m_43723_().m_21008_(ctx.m_43724_(), copy);
                }
                ctx.m_43725_().m_142346_((Entity)ctx.m_43723_(), GameEvent.f_157816_, fluidPos);
                return InteractionResult.m_19078_((boolean)ctx.m_43725_().f_46443_);
            }
            if (FluidUtil.tryPlaceFluid((Player)ctx.m_43723_(), (Level)ctx.m_43725_(), (InteractionHand)ctx.m_43724_(), (BlockPos)fluidPos, (IFluidHandler)handler, (FluidStack)new FluidStack(stored, 1000))) {
                if (ctx.m_43722_().m_41613_() > 1) {
                    ctx.m_43722_().m_41774_(1);
                    if (!ctx.m_43723_().m_150109_().m_36054_(copy)) {
                        ctx.m_43723_().m_36176_(copy, true);
                    }
                } else {
                    ctx.m_43723_().m_21008_(ctx.m_43724_(), copy);
                }
                ctx.m_43725_().m_142346_((Entity)ctx.m_43723_(), GameEvent.f_157769_, fluidPos);
                return InteractionResult.m_19078_((boolean)ctx.m_43725_().f_46443_);
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean handle(IFluidHandlerItem handler, IFluidHandler otherHandler) {
        FluidStack stored = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        FluidStack otherStored = otherHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (!otherStored.isEmpty()) {
            if (handler.fill(otherStored, IFluidHandler.FluidAction.SIMULATE) > 0 && otherHandler.drain(handler.fill(otherStored, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE).getAmount() > 0) {
                int ourFilled = handler.fill(otherStored, IFluidHandler.FluidAction.EXECUTE);
                otherHandler.drain(ourFilled, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (otherHandler.fill(stored, IFluidHandler.FluidAction.SIMULATE) > 0 && handler.drain(otherHandler.fill(stored, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE).getAmount() > 0) {
                int otherFilled = otherHandler.fill(stored, IFluidHandler.FluidAction.EXECUTE);
                handler.drain(otherFilled, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        } else if (!stored.isEmpty() && otherHandler.fill(stored, IFluidHandler.FluidAction.SIMULATE) > 0 && handler.drain(otherHandler.fill(stored, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE).getAmount() > 0) {
            int otherFilled = otherHandler.fill(stored, IFluidHandler.FluidAction.EXECUTE);
            handler.drain(otherFilled, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return (Integer)ServerConfig.canisterMax.get();
    }

    private void addInfo(String fluid, int amount, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.canister.fluid", (Object[])new Object[]{Component.m_237113_((String)fluid).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY).m_7220_((Component)(amount == 0 ? Component.m_237119_() : Component.m_237110_((String)"tooltip.canister.amount", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(amount)).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY))));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (ForgeCapabilities.FLUID_HANDLER_ITEM.isRegistered()) {
            stack.m_255036_(1).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
                FluidStack fs = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (fs.isEmpty()) {
                    this.addInfo("-", 0, tooltip);
                } else {
                    this.addInfo(fs.getDisplayName().getString(), fs.getAmount(), tooltip);
                }
            });
            return;
        }
        this.addInfo("-", 0, tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return !stack.m_41619_() ? new FluidHandlerItemStack(stack, this.getCapacity()) : null;
    }
}

