/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.items;

import bogdan.refueled.config.ServerConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class BatteryItem
extends Item {
    public BatteryItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (ForgeCapabilities.ENERGY != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.charge", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(((IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).resolve().get()).getEnergyStored())).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new EnergyStorageItem(stack, (Integer)ServerConfig.batteryMax.get());
        }
        return null;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        IEnergyStorage energy;
        if (context.m_43723_() == null || !context.m_43723_().m_6144_()) {
            return super.m_6225_(context);
        }
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (context.m_43722_().getCapability(ForgeCapabilities.ENERGY).isPresent() && (state.m_60713_(Blocks.f_50173_) || state.m_60713_(Blocks.f_152473_)) && (energy = (IEnergyStorage)context.m_43722_().getCapability(ForgeCapabilities.ENERGY).resolve().get()).receiveEnergy(8100, true) > 0) {
            energy.receiveEnergy(8100, false);
            if (!context.m_43725_().f_46443_) {
                context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 0.15f);
                if (state.m_60734_() == Blocks.f_50173_) {
                    context.m_43725_().m_46597_(context.m_8083_(), Blocks.f_50652_.m_152465_(state));
                } else {
                    context.m_43725_().m_46597_(context.m_8083_(), Blocks.f_152551_.m_152465_(state));
                }
            }
            return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        }
        return super.m_6225_(context);
    }

    public static class EnergyStorageItem
    implements IEnergyStorage,
    ICapabilityProvider {
        public static final String ENERGY_NBT_KEY = "Energy";
        private final LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this);
        @NotNull
        protected final ItemStack container;
        protected final int capacity;

        public EnergyStorageItem(@NotNull ItemStack stack, int energyCapacity) {
            this.container = stack;
            this.capacity = energyCapacity;
        }

        public int receiveEnergy(int amount, boolean simulate) {
            if (this.container.m_41613_() != 1 || amount < 0) {
                return 0;
            }
            int stored = this.getEnergyStored();
            int received = Math.min(this.getMaxEnergyStored() - stored, amount);
            if (!simulate) {
                this.setEnergyStored(stored + received);
            }
            return received;
        }

        public int extractEnergy(int amount, boolean simulate) {
            if (this.container.m_41613_() != 1 || amount < 0) {
                return 0;
            }
            int stored = this.getEnergyStored();
            if (stored == 0) {
                return 0;
            }
            int extracted = Math.min(stored, amount);
            if (!simulate) {
                this.setEnergyStored(stored - extracted);
            }
            return extracted;
        }

        public int getEnergyStored() {
            if (this.container.m_41783_() != null && this.container.m_41783_().m_128441_(ENERGY_NBT_KEY)) {
                return this.container.m_41783_().m_128451_(ENERGY_NBT_KEY);
            }
            return 0;
        }

        protected void setEnergyStored(int amount) {
            this.container.m_41784_().m_128405_(ENERGY_NBT_KEY, amount);
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
            return ForgeCapabilities.ENERGY.orEmpty(capability, this.lazyEnergy);
        }
    }
}

