/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.gui;

import bogdan.refueled.RefueledMain;
import bogdan.refueled.RefueledRegistry;
import bogdan.refueled.common.blocks.RoadMarkerBlock;
import bogdan.refueled.common.items.RoadMarkerItem;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class RoadMarkerGUI
extends AbstractContainerMenu {
    private final Container playerInventory;
    public final RoadMarkerItem roadMarker;
    public ContainerLevelAccess access;

    public RoadMarkerGUI(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public RoadMarkerGUI(int id, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)RefueledRegistry.ROAD_MARKER_GUI.get(), id);
        this.access = access;
        this.playerInventory = playerInventory;
        this.roadMarker = (RoadMarkerItem)playerInventory.f_35978_.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        this.addPlayerInventorySlots();
    }

    public boolean m_6366_(@NotNull Player player, int id) {
        if (id > 0 && id < 16) {
            this.roadMarker.SelectedColor = RoadMarkerBlock.MarkerColor.values()[id];
            return true;
        }
        if (id == 16) {
            this.roadMarker.SelectedBlock = null;
            return true;
        }
        if (id > 16) {
            if ((id -= 16) >= RefueledRegistry.Markers.size()) {
                RefueledMain.LOGGER.debug("Menu button ID passed into the road marker's GUI is higher than expected");
                return false;
            }
            this.roadMarker.SelectedBlock = (Block)RefueledRegistry.Markers.get(id).get();
            return true;
        }
        return false;
    }

    private void addPlayerInventorySlots() {
        if (this.playerInventory != null) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_38897_(new Slot(this.playerInventory, j + i * 9 + 9, 8 + j * 18, 94 + i * 18));
                }
            }
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot(this.playerInventory, k, 8 + k * 18, 152));
            }
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@NotNull Player player) {
        return player.m_6084_();
    }
}

