/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.gui;

import bogdan.refueled.RefueledRegistry;
import bogdan.refueled.common.blocks.blockentities.GasStationBlockEntity;
import bogdan.refueled.config.ServerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class GasStationGUI
extends AbstractContainerMenu {
    private final Container playerInventory;
    public final GasStationBlockEntity gasStation;
    public final DataSlot fuelButton;
    public final int[] entitySlots;
    public final List<Integer> foundEntities = new ArrayList<Integer>();

    public GasStationGUI(int id, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(id, playerInventory, (GasStationBlockEntity)((Object)playerInventory.f_35978_.m_9236_().m_141902_(extraData.m_130135_(), (BlockEntityType)RefueledRegistry.GAS_STATION_BLOCK_ENTITY.get()).get()), extraData.m_130116_(4));
    }

    public GasStationGUI(int id, Inventory playerInventory, final GasStationBlockEntity gasStation, int[] foundEntities) {
        super((MenuType)RefueledRegistry.GAS_STATION_GUI.get(), id);
        this.playerInventory = playerInventory;
        this.gasStation = gasStation;
        Arrays.stream(foundEntities).filter(entityId -> entityId != -1).forEach(this.foundEntities::add);
        this.fuelButton = DataSlot.m_39401_();
        this.entitySlots = new int[4];
        this.m_38897_(new Slot(gasStation.inventory, 0, 152, 22){

            public boolean m_5857_(ItemStack pStack) {
                if (pStack.m_41720_() instanceof BucketItem) {
                    return false;
                }
                LazyOptional lazy = pStack.m_255036_(1).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                if (lazy.isPresent() && gasStation.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()) {
                    IFluidHandlerItem itemHandler = (IFluidHandlerItem)lazy.resolve().get();
                    IFluidHandler handler = (IFluidHandler)gasStation.getCapability(ForgeCapabilities.FLUID_HANDLER).resolve().get();
                    FluidStack ourStored = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    FluidStack itemStored = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    if (!ourStored.isEmpty()) {
                        return itemStored.isEmpty() || ourStored.getFluid() == itemStored.getFluid();
                    }
                    return ServerConfig.getFuelEfficiency(itemStored.getFluid()) > 0.0f;
                }
                return false;
            }
        });
        this.m_38897_(new Slot(gasStation.inventory, 1, 152, 40){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }

            public boolean m_8010_(Player pPlayer) {
                return false;
            }

            public boolean m_280329_() {
                return false;
            }
        });
        this.m_38897_(new Slot(gasStation.inventory, 2, 152, 58){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }
        });
        this.m_38895_(this.fuelButton);
        this.m_38895_(DataSlot.m_39406_((int[])this.entitySlots, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.entitySlots, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.entitySlots, (int)2));
        this.m_38895_(DataSlot.m_39406_((int[])this.entitySlots, (int)3));
        this.addPlayerInventorySlots();
    }

    public boolean m_6366_(@NotNull Player player, int id) {
        if (id == 0) {
            if (this.gasStation.selected == null) {
                return false;
            }
            this.gasStation.fuelVehicle();
            return true;
        }
        if (id >= 1 && id <= this.entitySlots.length) {
            Entity selected = player.m_9236_().m_6815_(this.foundEntities.get(--id).intValue());
            this.gasStation.selected = this.gasStation.selected == selected ? null : selected;
            return true;
        }
        return false;
    }

    private void addPlayerInventorySlots() {
        if (this.playerInventory != null) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_38897_(new Slot(this.playerInventory, j + i * 9 + 9, 8 + j * 18, 94 + i * 18));
                }
            }
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot(this.playerInventory, k, 8 + k * 18, 152));
            }
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index < this.gasStation.inventory.m_6643_() ? !this.m_38903_(stack, this.gasStation.inventory.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(stack, 0, this.gasStation.inventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return !this.gasStation.m_58901_() && player.m_6084_() && GasStationGUI.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)this.gasStation.m_58899_()), (Player)player, (Block)this.gasStation.m_58900_().m_60734_());
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.gasStation.inventory.m_5785_(player);
    }
}

