/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.blocks.blockentities;

import bogdan.refueled.RefueledRegistry;
import bogdan.refueled.Utils;
import bogdan.refueled.config.ServerConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GasStationBlockEntity
extends BlockEntity {
    public final FluidTank tank;
    public final Container inventory;
    private final LazyOptional<IFluidHandler> fluidHandler;
    private final LazyOptional<IItemHandler> itemHandler;
    public final AABB fuelingBox;
    public Entity selected;
    private static final AABB NorthSouthBox = new AABB(-1.5, -0.5, -3.5, 1.5, 2.0, 3.5);
    private static final AABB EastWestBox = new AABB(-3.5, -0.5, -1.5, 3.5, 2.0, 1.5);
    public boolean fueling = false;
    public boolean fuelingItem = false;
    public boolean drainingItem = false;

    public GasStationBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RefueledRegistry.GAS_STATION_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.fuelingBox = GasStationBlockEntity.getFuelingBox(pPos, pBlockState);
        this.tank = new FluidTank(this.getFuelCapacity(), fs -> ServerConfig.getFuelEfficiency(fs.getFluid()) > 0.0f){

            protected void onContentsChanged() {
                GasStationBlockEntity.this.m_6596_();
            }
        };
        this.fluidHandler = LazyOptional.of(() -> this.tank);
        this.inventory = new SimpleContainer(3);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper(this.inventory));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if ((side == null || side == Direction.DOWN || this.canReachHandler(this.m_58900_(), side)) && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getFuelCapacity() {
        return (Integer)ServerConfig.gasStationMax.get();
    }

    private boolean canReachHandler(BlockState state, Direction side) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return side == Direction.WEST || side == Direction.EAST;
        }
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return side == Direction.NORTH || side == Direction.SOUTH;
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        this.tank.readFromNBT(tag);
        Utils.readInventory(tag, "inventory", this.inventory);
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        this.tank.writeToNBT(tag);
        Utils.saveInventory(tag, "inventory", this.inventory);
        super.m_183515_(tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.tank.writeToNBT(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.tank.readFromNBT(tag);
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            GasStationBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
            if (!this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
        }
    }

    public static AABB getFuelingBox(BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return NorthSouthBox.m_82383_(pos.m_252807_());
        }
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return EastWestBox.m_82383_(pos.m_252807_());
        }
        return new AABB(0.0, -0.5, 0.0, 0.0, 2.0, 0.0).m_82383_(pos.m_252807_());
    }

    public void fuelVehicle() {
        if (this.f_58857_ != null) {
            List<Entity> entities;
            if (this.selected == null && (entities = this.f_58857_.m_45933_(null, this.fuelingBox).stream().filter(e -> e.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()).toList()).size() == 1) {
                this.selected = entities.get(0);
            }
            if (this.selected != null) {
                this.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> this.selected.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(entityHandler -> {
                    FluidStack fuel = new FluidStack(this.tank.getFluid(), ((Integer)ServerConfig.gasStationTransferMax.get()).intValue());
                    if (!this.tank.isEmpty() && entityHandler.fill(fuel, IFluidHandler.FluidAction.SIMULATE) > 0) {
                        FluidStack filled = handler.drain(((Integer)ServerConfig.gasStationTransferMax.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
                        entityHandler.fill(filled, IFluidHandler.FluidAction.EXECUTE);
                        this.fueling = true;
                    } else {
                        this.fueling = false;
                    }
                }));
            }
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        int maxTransfer = (Integer)ServerConfig.gasStationTransferMax.get();
        GasStationBlockEntity gasStation = (GasStationBlockEntity)blockEntity;
        LazyOptional uncastHandler = gasStation.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Container inv = gasStation.inventory;
        uncastHandler.ifPresent(handler -> {
            FluidStack ourStored = handler.drain(maxTransfer, IFluidHandler.FluidAction.SIMULATE);
            if (gasStation.fueling) {
                gasStation.fuelVehicle();
            }
            if (!inv.m_8020_(1).m_41619_()) {
                ItemStack copy = inv.m_8020_(1).m_255036_(1);
                copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(itemHandler -> {
                    FluidStack itemStored = itemHandler.drain(maxTransfer, IFluidHandler.FluidAction.SIMULATE);
                    if (gasStation.fuelingItem) {
                        gasStation.drainingItem = false;
                        if (itemHandler.fill(ourStored, IFluidHandler.FluidAction.SIMULATE) > 0) {
                            int filled = itemHandler.fill(ourStored, IFluidHandler.FluidAction.EXECUTE);
                            handler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                            if (filled < maxTransfer || handler.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                                gasStation.fuelingItem = false;
                            }
                            if (!gasStation.fuelingItem) {
                                GasStationBlockEntity.tryToOutput(copy, gasStation);
                            } else {
                                inv.m_6836_(1, copy);
                            }
                            gasStation.m_6596_();
                        } else {
                            gasStation.fuelingItem = false;
                            GasStationBlockEntity.tryToOutput(copy, gasStation);
                            gasStation.m_6596_();
                        }
                    } else if (gasStation.drainingItem) {
                        if (handler.fill(itemStored, IFluidHandler.FluidAction.SIMULATE) > 0) {
                            int filled = handler.fill(itemStored, IFluidHandler.FluidAction.EXECUTE);
                            itemHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                            if (filled < maxTransfer || itemHandler.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                                gasStation.drainingItem = false;
                            }
                            if (!gasStation.drainingItem) {
                                GasStationBlockEntity.tryToOutput(copy, gasStation);
                            } else {
                                inv.m_6836_(1, copy);
                            }
                            gasStation.m_6596_();
                        } else {
                            gasStation.drainingItem = false;
                            GasStationBlockEntity.tryToOutput(copy, gasStation);
                            gasStation.m_6596_();
                        }
                    } else {
                        ItemStack output = inv.m_8020_(2);
                        if (output.m_41619_() || output.m_255036_(1).equals(copy, true)) {
                            inv.m_6836_(1, ItemStack.f_41583_);
                            if (output.m_41619_()) {
                                inv.m_6836_(2, copy);
                            } else {
                                output.m_41769_(1);
                            }
                            gasStation.m_6596_();
                        }
                    }
                });
            } else if (!inv.m_8020_(0).m_41619_()) {
                ItemStack original = inv.m_8020_(0);
                ItemStack copy = original.m_255036_(1);
                copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(itemHandler -> {
                    FluidStack itemStored = itemHandler.drain(maxTransfer, IFluidHandler.FluidAction.SIMULATE);
                    if (!itemStored.isEmpty()) {
                        if (handler.fill(itemStored, IFluidHandler.FluidAction.SIMULATE) > 0) {
                            int filled = handler.fill(itemStored, IFluidHandler.FluidAction.EXECUTE);
                            itemHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                            if (original.m_41613_() > 1) {
                                original.m_41774_(1);
                            } else {
                                inv.m_6836_(0, ItemStack.f_41583_);
                            }
                            if (filled == maxTransfer) {
                                gasStation.drainingItem = true;
                                inv.m_6836_(1, copy);
                            } else {
                                inv.m_6836_(2, copy);
                            }
                            gasStation.m_6596_();
                        }
                    } else if (!ourStored.isEmpty() && itemHandler.fill(ourStored, IFluidHandler.FluidAction.SIMULATE) > 0) {
                        int filled = itemHandler.fill(ourStored, IFluidHandler.FluidAction.EXECUTE);
                        handler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                        if (original.m_41613_() > 1) {
                            original.m_41774_(1);
                        } else {
                            inv.m_6836_(0, ItemStack.f_41583_);
                        }
                        if (filled == maxTransfer) {
                            gasStation.fuelingItem = true;
                            inv.m_6836_(1, copy);
                        } else {
                            inv.m_6836_(2, copy);
                        }
                        gasStation.m_6596_();
                    }
                });
            } else {
                gasStation.fuelingItem = false;
                gasStation.drainingItem = false;
            }
        });
    }

    public Component getFluidText() {
        if (this.tank.isEmpty()) {
            return Component.m_237115_((String)"block.refueled.gas_station.empty");
        }
        return Component.m_237115_((String)this.tank.getFluid().getFluid().getFluidType().getDescriptionId());
    }

    public Component getAmountText() {
        if (this.tank.isEmpty()) {
            return Component.m_237113_((String)"- mB");
        }
        return Component.m_237110_((String)"tooltip.canister.amount", (Object[])new Object[]{this.tank.getFluid().getAmount()});
    }

    public static void tryToOutput(ItemStack copy, GasStationBlockEntity gasStation) {
        ItemStack output = gasStation.inventory.m_8020_(2);
        if (output.m_41619_()) {
            gasStation.inventory.m_6836_(1, ItemStack.f_41583_);
            gasStation.inventory.m_6836_(2, copy);
        } else if (output.m_255036_(1).equals(copy, true)) {
            gasStation.inventory.m_6836_(1, ItemStack.f_41583_);
            output.m_41769_(1);
        } else {
            gasStation.inventory.m_6836_(1, copy);
        }
        gasStation.m_6596_();
    }
}

