/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PostBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<PostType> POST_TYPE = EnumProperty.m_61587_((String)"post_type", PostType.class);
    public static final VoxelShape CornerNorth = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    public static final VoxelShape CornerEast = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CornerSouth = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
    public static final VoxelShape CornerWest = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
    public static final VoxelShape SideNorth = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)2.0);
    public static final VoxelShape SideEast = Block.m_49796_((double)14.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final VoxelShape SideSouth = Block.m_49796_((double)7.0, (double)0.0, (double)14.0, (double)9.0, (double)16.0, (double)16.0);
    public static final VoxelShape SideWest = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)2.0, (double)16.0, (double)9.0);
    public static final VoxelShape Middle = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);

    public PostBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60999_().m_155954_(0.5f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(POST_TYPE, (Comparable)((Object)PostType.side)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, POST_TYPE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack item = pPlayer.m_21120_(pHand);
        if (item.m_150930_(Items.f_42574_) || item.m_204131_().anyMatch(tag -> tag.f_203868_().toString().equals("forge:tools/wrench"))) {
            if (!pLevel.f_46443_) {
                PostType type = (PostType)((Object)pState.m_61143_(POST_TYPE));
                BlockState state = (BlockState)pState.m_61124_(POST_TYPE, (Comparable)((Object)PostType.values()[type.ordinal() == 2 ? 0 : type.ordinal() + 1]));
                pLevel.m_7731_(pPos, state, 3);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        PostType type = (PostType)((Object)pState.m_61143_(POST_TYPE));
        Direction direction = (Direction)pState.m_61143_((Property)f_54117_);
        switch (type) {
            case side: {
                switch (direction) {
                    case NORTH: {
                        return SideNorth;
                    }
                    case EAST: {
                        return SideEast;
                    }
                    case SOUTH: {
                        return SideSouth;
                    }
                    case WEST: {
                        return SideWest;
                    }
                }
                break;
            }
            case corner: {
                switch (direction) {
                    case NORTH: {
                        return CornerNorth;
                    }
                    case EAST: {
                        return CornerEast;
                    }
                    case SOUTH: {
                        return CornerSouth;
                    }
                    case WEST: {
                        return CornerWest;
                    }
                }
                break;
            }
            case middle: {
                return Middle;
            }
        }
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public static enum PostType implements StringRepresentable
    {
        side,
        corner,
        middle;


        public String m_7912_() {
            return this.name();
        }
    }
}

