/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.client.gui;

import bogdan.refueled.common.gui.TruckGUI;
import com.dragn0007.dragnvehicles.vehicle.truck.Truck;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TruckGUIScreen
extends AbstractContainerScreen<TruckGUI> {
    private final Inventory playerInv;
    private final Truck truck;
    private static final int fontColor = 0x404040;
    public static final ResourceLocation TRUCK_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"refueled", (String)"textures/gui/truck_gui.png");
    private boolean focused;
    private boolean dragging;
    private final int maxOffset = 89;
    private final int maxSteps;
    private int currentOffset = 0;
    private int lastOffset = 0;
    private int renderedCount = 0;

    public TruckGUIScreen(TruckGUI truckGUI, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)truckGUI, playerInv, title);
        this.playerInv = playerInv;
        this.truck = truckGUI.truck;
        this.maxSteps = this.truck.inventory.m_6643_() / 8 - (this.truck.inventory.m_6643_() % 8 == 0 ? 6 : 5);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
        this.drawSlots();
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TRUCK_GUI_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 0; i < this.renderedCount; ++i) {
            guiGraphics.m_280218_(TRUCK_GUI_TEXTURE, this.f_97735_ + 7 + i % 8 * 18, this.f_97736_ + 17 + i / 8 * 18, 186, 0, 18, 18);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TRUCK_GUI_TEXTURE, 155, 18 + this.currentOffset, 176, this.maxSteps > 0 ? (this.focused || this.dragging ? 17 : 0) : 34, 10, 17);
        guiGraphics.m_280649_(this.f_96547_, this.truck.m_5446_().m_7532_(), 7, 7, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 7, 129, 0x404040, false);
        this.m_280072_(guiGraphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
    }

    private void drawSlots() {
        this.renderedCount = 0;
        int currentRow = this.currentOffset * this.maxSteps / 89 * 8;
        for (int i = 0; i < this.truck.inventory.m_6643_(); ++i) {
            if (currentRow <= i && i < Math.min(this.truck.inventory.m_6643_(), currentRow + 48)) {
                Slot slot = new Slot((Container)this.truck.inventory, i, 8 + i % 8 * 18, 18 + (i - currentRow) / 8 * 18);
                slot.f_40219_ = i;
                ((TruckGUI)this.m_6262_()).f_38839_.set(i, (Object)slot);
                ++this.renderedCount;
                continue;
            }
            ((TruckGUI)this.m_6262_()).f_38839_.set(i, (Object)new Slot((Container)this.truck.inventory, i, 152, 18){

                public boolean m_280329_() {
                    return false;
                }

                public boolean m_5857_(@NotNull ItemStack pStack) {
                    return false;
                }

                public boolean m_8010_(@NotNull Player pPlayer) {
                    return false;
                }

                public boolean m_6659_() {
                    return false;
                }
            });
        }
    }

    protected void m_181908_() {
        if (this.maxSteps > 0 && this.currentOffset != this.lastOffset) {
            this.drawSlots();
            this.lastOffset = this.currentOffset;
        }
        super.m_181908_();
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (super.m_6050_(pMouseX, pMouseY, pDelta)) {
            return true;
        }
        if (this.maxSteps > 0 && (double)(this.f_97735_ + 7) <= pMouseX && pMouseX <= (double)(this.f_97735_ + 166) && (double)(this.f_97736_ + 17) <= pMouseY && pMouseY <= (double)(this.f_97736_ + 17 + 108)) {
            int nextStep = this.currentOffset * this.maxSteps / 89 - Mth.m_14107_((double)pDelta);
            this.currentOffset = Mth.m_14045_((int)(nextStep * 89 / this.maxSteps), (int)0, (int)89);
            return true;
        }
        return false;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.maxSteps > 0 && (double)(this.f_97735_ + 155) <= pMouseX && pMouseX <= (double)(this.f_97735_ + 165) && (double)(this.f_97736_ + 18 + this.currentOffset) <= pMouseY && pMouseY <= (double)(this.f_97736_ + 35 + this.currentOffset)) {
            this.focused = !this.focused;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.maxSteps > 0) {
            if (!this.dragging && (double)(this.f_97735_ + 155) <= pMouseX && pMouseX <= (double)(this.f_97735_ + 165) && (double)(this.f_97736_ + 18 + this.currentOffset) <= pMouseY && pMouseY <= (double)(this.f_97736_ + 35 + this.currentOffset)) {
                this.dragging = true;
            }
            if (this.dragging) {
                this.currentOffset = Mth.m_14045_((int)(this.currentOffset + Mth.m_14107_((double)pDragY)), (int)0, (int)89);
                return true;
            }
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (this.maxSteps > 0 && this.dragging) {
            this.dragging = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }
}

