/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.client.gui;

import bogdan.refueled.RefueledRegistry;
import bogdan.refueled.common.blocks.RoadMarkerBlock;
import bogdan.refueled.common.gui.RoadMarkerGUI;
import bogdan.refueled.common.items.RoadMarkerItem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class RoadMarkerGUIScreen
extends AbstractContainerScreen<RoadMarkerGUI> {
    private int marker;
    private int color;
    private final RoadMarkerItem roadMarker;
    private final Inventory playerInv;
    private static final int fontColor = 0x404040;
    public static final ResourceLocation ROAD_MARKER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"refueled", (String)"textures/gui/road_marker_gui.png");

    public RoadMarkerGUIScreen(RoadMarkerGUI roadMarkerGUI, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)roadMarkerGUI, playerInv, title);
        this.playerInv = playerInv;
        this.roadMarker = roadMarkerGUI.roadMarker;
        this.marker = RefueledRegistry.Markers.stream().map(RegistryObject::get).toList().indexOf(this.roadMarker.SelectedBlock);
        this.color = this.roadMarker.SelectedColor.ordinal();
        this.f_97726_ = 176;
        this.f_97727_ = 176;
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(ROAD_MARKER_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    private void renderMarker(GuiGraphics graphics, int marker, int x, int y) {
        if (marker == -1) {
            return;
        }
        if (marker < -1) {
            marker += RefueledRegistry.Markers.size();
        } else if (marker >= RefueledRegistry.Markers.size()) {
            marker -= RefueledRegistry.Markers.size();
        }
        graphics.m_280480_(((BlockItem)RefueledRegistry.MarkerItems.get(marker).get()).m_7968_(), x, y);
    }

    private void renderColor(GuiGraphics graphics, int color, int x, int y) {
        if (color < 0) {
            color += 16;
        } else if (color > 15) {
            color -= 16;
        }
        graphics.m_280509_(x, y, x + 16, y + 16, RoadMarkerBlock.MarkerColor.values()[color].color);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 7, 83, 0x404040, false);
        this.renderMarker(guiGraphics, this.marker - 1, 62, 22);
        this.renderMarker(guiGraphics, this.marker, 62, 40);
        this.renderMarker(guiGraphics, this.marker + 1, 62, 58);
        this.renderColor(guiGraphics, this.color - 1, 98, 22);
        this.renderColor(guiGraphics, this.color, 98, 40);
        this.renderColor(guiGraphics, this.color + 1, 98, 58);
        this.m_280072_(guiGraphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int x = Mth.m_14107_((double)pMouseX) - this.f_97735_;
        int y = Mth.m_14107_((double)pMouseY) - this.f_97736_;
        if (x >= 61 && x < 79) {
            if (y >= 21 && y < 39) {
                if (--this.marker < -1) {
                    this.marker = RefueledRegistry.Markers.size() - 1;
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if (y >= 57 && y < 75) {
                if (++this.marker >= RefueledRegistry.Markers.size()) {
                    this.marker = -1;
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
        } else if (x >= 97 && x < 115) {
            if (y >= 21 && y < 39) {
                if (--this.color < 0) {
                    this.color = 15;
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if (y >= 57 && y < 75) {
                if (++this.color > 15) {
                    this.color = 0;
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int x = Mth.m_14107_((double)pMouseX) - this.f_97735_;
        int y = Mth.m_14107_((double)pMouseY) - this.f_97736_;
        if (y >= 39 && y < 57) {
            if (x >= 61 && x < 79) {
                if (pDelta < 0.0) {
                    if (++this.marker >= RefueledRegistry.Markers.size()) {
                        this.marker = -1;
                    }
                } else if (--this.marker < -1) {
                    this.marker = RefueledRegistry.Markers.size() - 1;
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if (x >= 97 && x < 115) {
                if (pDelta < 0.0) {
                    if (++this.color > 15) {
                        this.color = 0;
                    }
                } else if (--this.color < 0) {
                    this.color = 15;
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public void m_7379_() {
        if (this.marker - 1 != RefueledRegistry.Markers.stream().map(RegistryObject::get).toList().indexOf(this.roadMarker.SelectedBlock) && this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
            this.f_96541_.f_91072_.m_105208_(((RoadMarkerGUI)this.f_97732_).f_38840_, this.marker + 16);
        }
        if (this.color != this.roadMarker.SelectedColor.ordinal() && this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
            this.f_96541_.f_91072_.m_105208_(((RoadMarkerGUI)this.f_97732_).f_38840_, this.color);
        }
        super.m_7379_();
    }
}

