/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.client.gui;

import bogdan.refueled.common.blocks.blockentities.GasStationBlockEntity;
import bogdan.refueled.common.gui.GasStationGUI;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class GasStationGUIScreen
extends AbstractContainerScreen<GasStationGUI> {
    private final Inventory playerInv;
    private final GasStationBlockEntity gasStation;
    private int clicked = 0;
    private static final int fontColor = 0x404040;
    public static final ResourceLocation GAS_STATION_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"refueled", (String)"textures/gui/gas_station_gui.png");
    private boolean released = false;

    public GasStationGUIScreen(GasStationGUI gasStationGUI, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)gasStationGUI, playerInv, title);
        this.playerInv = playerInv;
        this.gasStation = gasStationGUI.gasStation;
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(GAS_STATION_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if ((mouseX -= this.f_97735_) >= 115 && mouseX < 133 && (mouseY -= this.f_97736_) >= 21 && mouseY < 39) {
            guiGraphics.m_280218_(GAS_STATION_TEXTURE, this.f_97735_ + 115, this.f_97736_ + 21, 176 + this.clicked, 18, 18, 18);
        } else {
            guiGraphics.m_280218_(GAS_STATION_TEXTURE, this.f_97735_ + 115, this.f_97736_ + 21, 176 + this.clicked, 0, 18, 18);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Component component = this.gasStation.getFluidText();
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280614_(this.f_96547_, component, 7, 10 + 9, 0x404040, false);
        Component component2 = this.gasStation.getAmountText();
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280614_(this.f_96547_, component2, 7, 10 + 9 * 2, 0x404040, false);
        ((GasStationGUI)this.f_97732_).foundEntities.forEach(id -> {
            Entity selected = this.playerInv.f_35978_.m_9236_().m_6815_(id.intValue());
            if (selected != null) {
                int index = ((GasStationGUI)this.f_97732_).foundEntities.indexOf(id);
                int color = 139;
                if (selected == this.gasStation.selected) {
                    RenderType renderType = RenderType.m_286086_();
                    Objects.requireNonNull(this.f_96547_);
                    int n = 10 + this.f_96547_.m_92895_(selected.m_5446_().getString());
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_285795_(renderType, 7, 37 + 9 * index + 2 * index, n, 39 + 9 * (index + 1) + 2 * index, 0, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
                    color = 85;
                } else if (this.isOverEntityList(mouseX, mouseY, index)) {
                    RenderType renderType = RenderType.m_286086_();
                    Objects.requireNonNull(this.f_96547_);
                    int n = 10 + this.f_96547_.m_92852_((FormattedText)selected.m_5446_());
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_285795_(renderType, 7, 37 + 9 * index + 2 * index, n, 39 + 9 * (index + 1) + 2 * index, 0, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
                }
                RenderType renderType = RenderType.m_286086_();
                Objects.requireNonNull(this.f_96547_);
                int n = 9 + this.f_96547_.m_92852_((FormattedText)selected.m_5446_());
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_285795_(renderType, 8, 38 + 9 * index + 4 * index, n, 38 + 9 * (index + 1) + 2 * index, 10, FastColor.ARGB32.m_13660_((int)255, (int)color, (int)color, (int)color));
                Component component = selected.m_5446_();
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280614_(this.f_96547_, component, 9, 39 + 9 * index, 0xFFFFFF, false);
            }
        });
        guiGraphics.m_280649_(this.f_96547_, this.gasStation.m_58900_().m_60734_().m_49954_().m_7532_(), 7, 7, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 7, 83, 0x404040, false);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 333.0f);
        guiGraphics.m_280398_(GAS_STATION_TEXTURE, 151, 39, 0, 176.0f, 36.0f, 18, 18, 256, 256);
        guiGraphics.m_280168_().m_85849_();
        this.m_280072_(guiGraphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pMouseX - (double)this.f_97735_ >= 115.0 && pMouseX - (double)this.f_97735_ < 133.0 && pMouseY - (double)this.f_97736_ >= 21.0 && pMouseY - (double)this.f_97736_ < 39.0) {
            this.clicked = 18;
            this.released = false;
            if (((GasStationGUI)this.f_97732_).m_6366_(this.playerInv.f_35978_, 0)) {
                if (this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
                    this.f_96541_.f_91072_.m_105208_(((GasStationGUI)this.f_97732_).f_38840_, 0);
                }
                return true;
            }
        }
        for (Integer id : ((GasStationGUI)this.f_97732_).foundEntities) {
            int index = ((GasStationGUI)this.f_97732_).foundEntities.indexOf(id);
            if (!this.isOverEntityList(pMouseX - (double)this.f_97735_, pMouseY - (double)this.f_97736_, index) || !((GasStationGUI)this.f_97732_).m_6366_(this.playerInv.f_35978_, index + 1)) continue;
            if (this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
                this.f_96541_.f_91072_.m_105208_(((GasStationGUI)this.f_97732_).f_38840_, index + 1);
            }
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.released && !this.gasStation.fueling) {
            this.clicked = 0;
        }
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.released = true;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOverEntityList(double mX, double mY, int index) {
        Entity entity = this.playerInv.f_35978_.m_9236_().m_6815_(((GasStationGUI)this.f_97732_).foundEntities.get(index).intValue());
        if (entity == null) {
            return false;
        }
        if (!(mX >= 7.0)) return false;
        if (!(mX < (double)(10 + this.f_96547_.m_92895_(entity.m_5446_().getString())))) return false;
        Objects.requireNonNull(this.f_96547_);
        if (!(mY >= (double)(37 + 9 * index + 2 * index))) return false;
        Objects.requireNonNull(this.f_96547_);
        if (!(mY < (double)(39 + 9 * (index + 1) + 2 * index))) return false;
        return true;
    }
}

