/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.client.gui;

import bogdan.refueled.Utils;
import bogdan.refueled.common.accessors.IVehicleAccess;
import bogdan.refueled.common.gui.CarGUI;
import bogdan.refueled.config.ClientConfig;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class CarGUIScreen
extends AbstractContainerScreen<CarGUI> {
    private static final ResourceLocation CAR_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"refueled", (String)"textures/gui/vehicle_gui.png");
    private static final int fontColor = 0x404040;
    private final Inventory playerInv;
    private final Entity car;
    private Label fuelLabel;
    private Label healthLabel;
    private Label batteryLabel;
    private Label tempLabel;
    private int ticksSinceAnyHover = 0;

    public CarGUIScreen(CarGUI carGUI, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)carGUI, playerInv, title);
        this.playerInv = playerInv;
        this.car = carGUI.car;
        this.f_97726_ = 176;
        this.f_97727_ = 218;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280649_(this.f_96547_, this.car.m_5446_().m_7532_(), 7, 55, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 7, 123, 0x404040, false);
        this.m_280072_(guiGraphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(CAR_GUI_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.fuelLabel = (Label)this.m_142416_((GuiEventListener)new Label(LabelType.FUEL, this.f_96547_, this.f_97735_, this.f_97736_, 0x404040));
        this.healthLabel = (Label)this.m_142416_((GuiEventListener)new Label(LabelType.HEALTH, this.f_96547_, this.f_97735_, this.f_97736_, 0x404040));
        this.batteryLabel = (Label)this.m_142416_((GuiEventListener)new Label(LabelType.BATTERY, this.f_96547_, this.f_97735_, this.f_97736_, 0x404040));
        this.tempLabel = (Label)this.m_142416_((GuiEventListener)new Label(LabelType.TEMPERATURE, this.f_96547_, this.f_97735_, this.f_97736_, 0x404040));
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 127, this.f_97736_ + 7, 19, 19, false));
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 150, this.f_97736_ + 7, 19, 19, true));
    }

    protected void m_181908_() {
        this.ticksSinceAnyHover = ClientConfig.pinnedType.get() != LabelType.NONE && !this.fuelLabel.m_274382_() && !this.healthLabel.m_274382_() && !this.batteryLabel.m_274382_() && !this.tempLabel.m_274382_() ? Math.min(3, this.ticksSinceAnyHover + 1) : 0;
        super.m_181908_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (!(ClientConfig.pinnedType.get() == LabelType.NONE || this.fuelLabel.m_274382_() || this.healthLabel.m_274382_() || this.batteryLabel.m_274382_() || this.tempLabel.m_274382_())) {
            LabelType type = (LabelType)((Object)ClientConfig.pinnedType.get());
            int texOffset = Mth.m_14107_((double)(40.0 * (double)this.fuelLabel.getPercent(type) * 0.01 * (double)this.ticksSinceAnyHover / 3.0));
            guiGraphics.m_280218_(CAR_GUI_TEXTURE, this.f_97735_ + 8, this.f_97736_ + 48 - texOffset, 176 + 11 * type.getInt(), 40 - texOffset, 11, texOffset);
        }
    }

    public Component[] getFuelString() {
        return new Component[]{Component.m_237110_((String)"gui.refueled.fuel.unit", (Object[])new Object[]{((IVehicleAccess)this.car).refuel$getMaxFuel()}), Component.m_237115_((String)"gui.refueled.fuel")};
    }

    public Component[] getHealthString() {
        float max = ((IVehicleAccess)this.car).refuel$getMaxHealth();
        return new Component[]{Component.m_237110_((String)"gui.refueled.health.unit", (Object[])new Object[]{(double)max == Math.floor(max) ? String.valueOf(Mth.m_14143_((float)max)) : Float.valueOf(max)}), Component.m_237115_((String)"gui.refueled.health")};
    }

    public Component[] getBatteryString() {
        return new Component[]{Component.m_237110_((String)"gui.refueled.battery.unit", (Object[])new Object[]{((IVehicleAccess)this.car).refuel$getMaxBattery()}), Component.m_237115_((String)"gui.refueled.battery")};
    }

    public Component[] getTemperatureString() {
        return new Component[]{Component.m_237113_((String)"\u00b0F"), Component.m_237113_((String)"\u00b0C")};
    }

    public int getFuel() {
        return ((IVehicleAccess)this.car).refuel$getFuel();
    }

    public float getHealth() {
        return Utils.round(((IVehicleAccess)this.car).refuel$getHealth(), 2);
    }

    public int getBattery() {
        return ((IVehicleAccess)this.car).refuel$getBattery();
    }

    public float getTemperature() {
        if (((Boolean)ClientConfig.temperatureFahrenheit.get()).booleanValue()) {
            return Utils.round(((IVehicleAccess)this.car).refuel$getTemperature() * 1.8f + 32.0f, 2);
        }
        return Utils.round(((IVehicleAccess)this.car).refuel$getTemperature(), 2);
    }

    private class Label
    extends AbstractWidget {
        public final LabelType type;
        private final int fontColor;
        private final int oX;
        private final int oY;
        private final Font font;
        private final Component[] string;
        private int lastTick;
        private int lastHoverTick;
        private boolean lastHovered;

        public Label(LabelType type, Font font, int pX, int pY, int fontColor) {
            int n = pY + 8 + 11 * type.getInt();
            int n2 = font.m_92852_((FormattedText)(new Component[][]{CarGUIScreen.this.getFuelString(), CarGUIScreen.this.getHealthString(), CarGUIScreen.this.getBatteryString(), CarGUIScreen.this.getTemperatureString()})[type.getInt()][Label.isOtherwise(type)]);
            Objects.requireNonNull(font);
            super(pX + 25, n, n2, 9, (Component)Component.m_237119_());
            this.lastTick = 0;
            this.lastHoverTick = 0;
            this.lastHovered = false;
            this.type = type;
            this.font = font;
            this.fontColor = fontColor;
            this.oX = pX;
            this.oY = pY;
            this.string = (new Component[][]{CarGUIScreen.this.getFuelString(), CarGUIScreen.this.getHealthString(), CarGUIScreen.this.getBatteryString(), CarGUIScreen.this.getTemperatureString()})[type.getInt()];
        }

        private static int isOtherwise(LabelType type) {
            return type == LabelType.TEMPERATURE && (Boolean)ClientConfig.temperatureFahrenheit.get() != false || type != LabelType.TEMPERATURE && (Boolean)ClientConfig.displayInUnits.get() != false ? 0 : 1;
        }

        private float getMax(LabelType type) {
            return (new float[]{((IVehicleAccess)CarGUIScreen.this.car).refuel$getMaxFuel(), ((IVehicleAccess)CarGUIScreen.this.car).refuel$getMaxHealth(), ((IVehicleAccess)CarGUIScreen.this.car).refuel$getMaxBattery(), 100.0f})[type.getInt()];
        }

        private float getNumber(LabelType type) {
            return (new float[]{CarGUIScreen.this.getFuel(), CarGUIScreen.this.getHealth(), CarGUIScreen.this.getBattery(), CarGUIScreen.this.getTemperature()})[type.getInt()];
        }

        public float getPercent(LabelType type) {
            if (type == LabelType.TEMPERATURE) {
                return Mth.m_14036_((float)((((IVehicleAccess)CarGUIScreen.this.car).refuel$getTemperature() + 50.0f) / 150.0f * 100.0f), (float)0.0f, (float)100.0f);
            }
            return Mth.m_14036_((float)(this.getNumber(type) / this.getMax(type) * 100.0f), (float)0.0f, (float)100.0f);
        }

        protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            float unit = this.getNumber(this.type);
            float percent = this.getPercent(this.type);
            int offset = Mth.m_14107_((double)(40.0 * (double)percent * 0.01));
            if (this.f_93622_) {
                int texOffset = Mth.m_14107_((double)Mth.m_14139_((double)partialTick, (double)(40.0 * (double)percent * 0.01 * 0.25 * (double)(this.lastHovered ? Math.min(4, this.lastTick - this.lastHoverTick + 1) : 0)), (double)(40.0 * (double)percent * 0.01 * 0.25 * (double)(this.lastHovered ? Math.min(4, CarGUIScreen.this.car.f_19797_ - this.lastHoverTick + 1) : 0))));
                guiGraphics.m_280218_(CAR_GUI_TEXTURE, this.oX + 8, this.oY + 48 - texOffset, 176 + 11 * this.type.getInt(), 40 - texOffset, 11, texOffset);
                if (this.type == LabelType.FUEL && this.lastTick - this.lastHoverTick >= 20) {
                    guiGraphics.m_280557_(this.font, (Component)Component.m_237115_((String)((IVehicleAccess)CarGUIScreen.this.car).refuel$getFluid().getFluidType().getDescriptionId()), mouseX, mouseY);
                }
            } else if (CarGUIScreen.this.car.f_19797_ != this.lastTick) {
                this.lastHoverTick = CarGUIScreen.this.car.f_19797_;
            }
            this.lastTick = CarGUIScreen.this.car.f_19797_;
            this.lastHovered = this.f_93622_;
            String number = String.valueOf(Utils.round(percent, 2));
            if (this.type == LabelType.TEMPERATURE) {
                number = String.valueOf(CarGUIScreen.this.getTemperature());
            } else if (((Boolean)ClientConfig.displayInUnits.get()).booleanValue()) {
                number = (double)unit == Math.floor(unit) ? String.valueOf(Mth.m_14143_((float)unit)) : String.valueOf(Utils.round(unit, 2));
            }
            int color = this.fontColor;
            try {
                int RGBA = NativeImage.m_85058_((InputStream)Minecraft.m_91087_().m_91098_().m_215595_(CAR_GUI_TEXTURE)).m_84985_(176 + 11 * this.type.getInt(), 40 - offset);
                if (this.f_93622_) {
                    color = ((((RGBA >> 24 & 0xFF) << 8) + (RGBA & 0xFF) << 8) + (RGBA >> 8 & 0xFF) << 8) + (RGBA >> 16 & 0xFF);
                } else {
                    byte alpha = Integer.valueOf(((RGBA >> 24 & 0xFF) + (this.fontColor & 0xFF)) / 2).byteValue();
                    byte red = Integer.valueOf(((RGBA & 0xFF) + (this.fontColor >> 8 & 0xFF)) / 2).byteValue();
                    byte green = Integer.valueOf(((RGBA >> 8 & 0xFF) + (this.fontColor >> 16 & 0xFF)) / 2).byteValue();
                    byte blue = Integer.valueOf(((RGBA >> 16 & 0xFF) + (this.fontColor >> 24 & 0xFF)) / 2).byteValue();
                    color = (((alpha << 8) + red << 8) + green << 8) + blue;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            guiGraphics.m_280056_(this.font, (String)(ClientConfig.pinnedType.get() == this.type ? String.valueOf('\u00a7') + ChatFormatting.UNDERLINE.m_178510_() : "") + number, this.m_252754_(), this.m_252907_(), color, false);
            guiGraphics.m_280614_(this.font, this.string[Label.isOtherwise(this.type)], this.m_252754_() + this.font.m_92895_(number), this.m_252907_(), this.fontColor, false);
            this.m_93674_(this.font.m_92895_(number));
        }

        protected void m_168797_(@NotNull NarrationElementOutput narrationElementOutput) {
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_93680_(mouseX, mouseY)) {
                if (ClientConfig.pinnedType.get() != this.type) {
                    ClientConfig.pinnedType.set((Object)this.type);
                } else {
                    ClientConfig.pinnedType.set((Object)LabelType.NONE);
                }
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    public static enum LabelType {
        NONE,
        FUEL,
        HEALTH,
        BATTERY,
        TEMPERATURE;


        public int getInt() {
            return this == NONE ? 4 : this.ordinal() - 1;
        }
    }

    private static class Button
    extends AbstractButton {
        private final boolean displayTemp;
        private boolean isDefault;

        public Button(int pX, int pY, int pWidth, int pHeight, boolean displayTemp) {
            super(pX, pY, pWidth, pHeight, (Component)(displayTemp ? Component.m_237113_((String)((Boolean)ClientConfig.temperatureFahrenheit.get() != false ? "\u00b0F" : "\u00b0C")) : Component.m_237113_((String)((Boolean)ClientConfig.displayInUnits.get() != false ? "/" : "%"))));
            this.displayTemp = displayTemp;
            this.isDefault = displayTemp ? (Boolean)ClientConfig.temperatureFahrenheit.get() : (Boolean)ClientConfig.displayInUnits.get();
        }

        public void m_5691_() {
            if (this.isDefault) {
                if (this.displayTemp) {
                    this.m_93666_((Component)Component.m_237113_((String)"\u00b0C"));
                    ClientConfig.temperatureFahrenheit.set((Object)false);
                } else {
                    this.m_93666_((Component)Component.m_237113_((String)"%"));
                    ClientConfig.displayInUnits.set((Object)false);
                }
                this.isDefault = false;
            } else {
                if (this.displayTemp) {
                    this.m_93666_((Component)Component.m_237113_((String)"\u00b0F"));
                    ClientConfig.temperatureFahrenheit.set((Object)true);
                } else {
                    this.m_93666_((Component)Component.m_237113_((String)"/"));
                    ClientConfig.displayInUnits.set((Object)true);
                }
                this.isDefault = true;
            }
        }

        public void m_7691_(double mouseX, double mouseY) {
            this.m_93692_(false);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_6035_());
        }
    }
}

