/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled;

import bogdan.refueled.common.accessors.IVehicleAccess;
import bogdan.refueled.common.blocks.blockentities.GasStationBlockEntity;
import com.dragn0007.dragnvehicles.item.CarItem;
import com.dragn0007.dragnvehicles.item.ClassicItem;
import com.dragn0007.dragnvehicles.item.MotorcycleItem;
import com.dragn0007.dragnvehicles.item.SUVItem;
import com.dragn0007.dragnvehicles.item.SportCarItem;
import com.dragn0007.dragnvehicles.item.TruckItem;
import com.dragn0007.dragnvehicles.vehicle.car.Car;
import com.dragn0007.dragnvehicles.vehicle.classic.Classic;
import com.dragn0007.dragnvehicles.vehicle.motorcycle.Motorcycle;
import com.dragn0007.dragnvehicles.vehicle.sportcar.SportCar;
import com.dragn0007.dragnvehicles.vehicle.suv.SUV;
import com.dragn0007.dragnvehicles.vehicle.truck.Truck;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public abstract class Utils {
    public static float mod(float n, float m) {
        while (n < 0.0f) {
            n += m;
        }
        return n % m;
    }

    public static boolean isInBounds(float number, float bound, float tolerance) {
        return number > bound - tolerance && number < bound + tolerance;
    }

    public static float subtractToZero(float num, float sub) {
        float erg;
        if (num < 0.0f) {
            erg = num + sub;
            if (erg > 0.0f) {
                erg = 0.0f;
            }
        } else {
            erg = num - sub;
            if (erg < 0.0f) {
                erg = 0.0f;
            }
        }
        return erg;
    }

    public static void readInventory(CompoundTag compound, String name, Container inv) {
        if (!compound.m_128441_(name)) {
            return;
        }
        ListTag tagList = compound.m_128437_(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag slot = tagList.m_128728_(i);
            int j = slot.m_128451_("Slot");
            if (j < 0 || j >= inv.m_6643_()) continue;
            inv.m_6836_(j, ItemStack.m_41712_((CompoundTag)slot));
        }
    }

    public static void saveInventory(CompoundTag compound, String name, Container inv) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("Slot", i);
            inv.m_8020_(i).m_41739_(slot);
            tagList.add((Object)slot);
        }
        compound.m_128365_(name, (Tag)tagList);
    }

    public static boolean isCar(Entity car) {
        return car instanceof Car || car instanceof Classic || car instanceof Truck || car instanceof SUV || car instanceof SportCar || car instanceof Motorcycle;
    }

    public static boolean isCar(Item item) {
        return item instanceof CarItem || item instanceof ClassicItem || item instanceof TruckItem || item instanceof SUVItem || item instanceof SportCarItem || item instanceof MotorcycleItem;
    }

    public static boolean isSoundPlaying(SoundInstance sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.m_91087_().m_91106_().m_120403_(sound);
    }

    public static float round(float value, int scale) {
        return (float)(Math.floor((double)value * Math.pow(10.0, scale)) * Math.pow(0.1, scale));
    }

    public static int getHP(Entity car) {
        return Mth.m_14143_((float)(((IVehicleAccess)car).refuel$getHealth() / ((IVehicleAccess)car).refuel$getMaxHealth() * 100.0f));
    }

    public static int[] getGasStationEntities(Level level, BlockPos pos) {
        List entities = level.m_45933_(null, GasStationBlockEntity.getFuelingBox(pos, level.m_8055_(pos)));
        int[] array = new int[4];
        for (int i = 0; i < 4; ++i) {
            array[i] = entities.size() - 1 >= i && ((Entity)entities.get(i)).getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent() ? ((Entity)entities.get(i)).m_19879_() : -1;
        }
        return array;
    }
}

