/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled;

import bogdan.refueled.RefueledRegistry;
import bogdan.refueled.client.GasStationBlockEntityRenderer;
import bogdan.refueled.client.events.KeyEvent;
import bogdan.refueled.client.events.RenderEvent;
import bogdan.refueled.client.gui.CarGUIScreen;
import bogdan.refueled.client.gui.GasStationGUIScreen;
import bogdan.refueled.client.gui.RoadMarkerGUIScreen;
import bogdan.refueled.client.gui.TruckGUIScreen;
import bogdan.refueled.common.network.RefueledChannel;
import bogdan.refueled.config.ClientConfig;
import bogdan.refueled.config.ServerConfig;
import bogdan.refueled.server.PlayerEvents;
import bogdan.refueled.server.RefueledCommands;
import com.mojang.logging.LogUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="refueled")
public class RefueledMain {
    public static final String MODID = "refueled";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static KeyMapping CAR_GUI_KEY;
    public static KeyMapping START_KEY;
    public static KeyMapping CENTER_KEY;

    public RefueledMain(FMLJavaModLoadingContext ctx) {
        IEventBus modEventBus = ctx.getModEventBus();
        ServerConfig.register(ctx);
        RefueledRegistry.init(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)new RefueledCommands());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ctx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
            modEventBus.addListener(this::onRegisterKeybinds);
            modEventBus.addListener(this::clientSetup);
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RefueledChannel.register();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvent());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvent());
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)RefueledRegistry.CAR_GUI.get()), CarGUIScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RefueledRegistry.TRUCK_GUI.get()), TruckGUIScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RefueledRegistry.GAS_STATION_GUI.get()), GasStationGUIScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RefueledRegistry.ROAD_MARKER_GUI.get()), RoadMarkerGUIScreen::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)RefueledRegistry.GAS_STATION_BLOCK_ENTITY.get()), GasStationBlockEntityRenderer::new);
        });
    }

    public void onRegisterKeybinds(RegisterKeyMappingsEvent event) {
        CAR_GUI_KEY = new KeyMapping("key.refueled.car_gui", 73, "category.refueled");
        START_KEY = new KeyMapping("key.refueled.car_start", 82, "category.refueled");
        CENTER_KEY = new KeyMapping("key.refueled.center_car", 32, "category.refueled");
        event.register(CAR_GUI_KEY);
        event.register(START_KEY);
        event.register(CENTER_KEY);
    }
}

