/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.event.EventJS;
import net.liopyu.entityjs.builders.modification.ModifyLivingEntityBuilder;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class}, priority=0, remap=true)
public abstract class LivingEntityRendererMixin<T, M extends EntityModel<?>> {
    @Shadow
    protected M f_115290_;
    @Unique
    private Object entityJs$builder;

    private LivingEntityRenderer<?, M> getRenderer() {
        return (LivingEntityRenderer)this;
    }

    @Inject(method={"getRenderType"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    private void onGetRenderType(LivingEntity entity, boolean bodyVisible, boolean translucent, boolean glowing, CallbackInfoReturnable<RenderType> cir) {
        Object builder;
        EntityType entityType = entity.m_6095_();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, (Entity)entity);
            Object object = eventJS.getBuilder();
            if (object instanceof ModifyLivingEntityBuilder) {
                builder = (ModifyLivingEntityBuilder)((Object)object);
                if (((ModifyLivingEntityBuilder)((Object)builder)).setTextureLocation == null && ((ModifyLivingEntityBuilder)((Object)builder)).setRenderType == null) {
                    return;
                }
            }
            EventHandlers.modifyEntity.post((EventJS)eventJS);
            this.entityJs$builder = eventJS.getBuilder();
        }
        if ((builder = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            Object obj;
            ContextUtils.RendererModelContext context;
            ModifyLivingEntityBuilder builder2 = (ModifyLivingEntityBuilder)((Object)builder);
            if (builder2.setTextureLocation != null) {
                context = new ContextUtils.RendererModelContext((Entity)entity, (EntityRenderer<?>)this.getRenderer(), (EntityModel<?>)this.f_115290_);
                try {
                    obj = builder2.setTextureLocation.apply(context);
                    Object resourcelocation = EntityJSHelperClass.convertObjectToDesired(obj, "resourcelocation");
                    if (resourcelocation != null) {
                        ResourceLocation textureLocation = (ResourceLocation)resourcelocation;
                        if (translucent) {
                            cir.setReturnValue((Object)RenderType.m_110467_((ResourceLocation)textureLocation));
                            return;
                        }
                        if (bodyVisible) {
                            cir.setReturnValue((Object)this.f_115290_.m_103119_(textureLocation));
                            return;
                        }
                        RenderType finalValue = glowing ? RenderType.m_110491_((ResourceLocation)textureLocation) : null;
                        cir.setReturnValue((Object)finalValue);
                        return;
                    }
                    if (obj != null) {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value in setTextureLocation field from entity: " + entity.m_6095_() + ". Value: " + resourcelocation + ". Must be a resource location");
                    }
                    return;
                }
                catch (Throwable e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in modifyEntity method setTextureLocation from entity: " + entity.m_6095_() + ". ", e);
                }
            }
            if (builder2.setRenderType != null) {
                context = new ContextUtils.RendererModelContext((Entity)entity, (EntityRenderer<?>)this.getRenderer(), (EntityModel<?>)this.f_115290_);
                try {
                    obj = builder2.setRenderType.apply(context);
                    RenderType returnValue = EntityJSHelperClass.convertToRenderType(obj, cir.getReturnValue());
                    if (returnValue != null) {
                        cir.setReturnValue((Object)returnValue);
                        return;
                    }
                    if (obj != null) {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value in setRenderType field from entity: " + entity.m_6095_() + ". Must return either a resource location or a RenderType. Return null for the default texture logic.");
                    }
                }
                catch (Throwable e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in modifyEntity method setRenderType from entity: " + entity.m_6095_() + ". ", e);
                }
            }
        }
    }
}

