/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import com.mojang.serialization.Dynamic;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.builders.modification.ModifyLivingEntityBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJSCustom;
import net.liopyu.entityjs.entities.living.entityjs.WrappedAnimatableEntity;
import net.liopyu.entityjs.events.BuildBrainEventJS;
import net.liopyu.entityjs.events.BuildBrainProviderEventJS;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EntityJSUtils;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.liopyu.entityjs.util.EventHandlers;
import net.liopyu.entityjs.util.implementation.ILivingEntityJS;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, remap=true)
public abstract class LivingEntityMixin
implements ILivingEntityJS {
    @Unique
    private Object entityJs$entityObject = this;
    @Unique
    public Object entityJs$builder;
    @Unique
    private WrappedAnimatableEntity entityJs$animatableEntity;
    @Unique
    private static final Map<Class<?>, Map<String, EntityDataAccessor<?>>> entityJs$classAccessorMap = new HashMap();
    @Unique
    private final Map<String, EntityDataAccessor<?>> entityJs$accessorMap = new HashMap();

    @Unique
    private LivingEntity entityJs$getLivingEntity() {
        return (LivingEntity)this.entityJs$entityObject;
    }

    @Unique
    private String entityJs$entityName() {
        return this.entityJs$getLivingEntity().m_6095_().toString();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=true)
    private void entityjs$onEntityInit(EntityType<?> pEntityType, Level pLevel, CallbackInfo ci) {
        Object customBuilder;
        EntityType entityType = this.entityJs$getLivingEntity().m_6095_();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, (Entity)this.entityJs$getLivingEntity());
            EventHandlers.modifyEntity.post((EventJS)eventJS);
            this.entityJs$builder = eventJS.getBuilder();
        }
        if ((customBuilder = EntityJSUtils.getEntityBuilder(pEntityType)) instanceof CustomEntityJSBuilder) {
            IAnimatableJSCustom wrappedEntity = this.ensureIAnimatableJS(this.entityJs$getLivingEntity());
            this.entityJs$setAnimatableEntity((WrappedAnimatableEntity)wrappedEntity);
        }
        this.entityJs$defineSynchedData();
    }

    private IAnimatableJSCustom ensureIAnimatableJS(LivingEntity entity) {
        if (entity instanceof IAnimatableJSCustom) {
            IAnimatableJSCustom animatableJS = (IAnimatableJSCustom)entity;
            return animatableJS;
        }
        Object customBuilder = EntityJSUtils.getEntityBuilder(entity.m_6095_());
        return new WrappedAnimatableEntity(entity, (CustomEntityJSBuilder)((Object)customBuilder));
    }

    @Override
    @Unique
    public WrappedAnimatableEntity entityJs$getAnimatableEntity() {
        return this.entityJs$animatableEntity;
    }

    @Unique
    private void entityJs$setAnimatableEntity(WrappedAnimatableEntity animatableEntity) {
        this.entityJs$animatableEntity = animatableEntity;
    }

    @Info(value="Calls a triggerable animation to be played anywhere.\n")
    public void triggerAnimation(String controllerName, String animName) {
        if (this.entityJs$getAnimatableEntity() != null) {
            this.entityJs$getAnimatableEntity().triggerAnim(controllerName, animName);
        }
    }

    @Override
    public void entityJs$addSyncedData(EntitySerializerType type, String key, Object value) {
        try {
            EntityDataAccessor accessor;
            String castHint = switch (type.toString().toLowerCase()) {
                case "byte", "int", "float", "long" -> type.toString().toLowerCase();
                default -> null;
            };
            Class<?> entityClass = this.entityJs$getLivingEntity().getClass();
            Map classMap = entityJs$classAccessorMap.computeIfAbsent(entityClass, k -> new HashMap());
            if (classMap.containsKey(key)) {
                accessor = (EntityDataAccessor)classMap.get(key);
            } else {
                EntityDataSerializer<?> serializer = type.getSerializer();
                accessor = SynchedEntityData.m_135353_(entityClass, serializer);
                classMap.put(key, accessor);
            }
            Object finalValue = EntitySerializerType.castValue(value, castHint);
            if (!this.entityJs$getLivingEntity().m_20088_().m_285897_(accessor)) {
                this.entityJs$getLivingEntity().m_20088_().m_135372_(accessor, finalValue);
            } else {
                this.entityJs$getLivingEntity().m_20088_().m_135381_(accessor, finalValue);
            }
            this.entityJs$accessorMap.put(key, accessor);
        }
        catch (Exception e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error adding synched data", e);
        }
    }

    @Override
    @Unique
    public void entityJs$addSyncedData(String identifier, Object value) {
        try {
            EntitySerializerType type;
            if (value instanceof Number) {
                Number num = (Number)value;
                double d = num.doubleValue();
                type = num instanceof Float ? EntitySerializerType.FLOAT : (num instanceof Long || d % 1.0 == 0.0 && d > 2.147483647E9 && d <= 9.223372036854776E18 ? EntitySerializerType.LONG : (num instanceof Integer || d % 1.0 == 0.0 && d >= -2.147483648E9 && d <= 2.147483647E9 ? EntitySerializerType.INT : EntitySerializerType.FLOAT));
            } else {
                type = EntitySerializerType.fromObject(value);
            }
            this.entityJs$addSyncedData(type, identifier, value);
        }
        catch (Exception e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error adding synched data", e);
        }
    }

    @Override
    @Unique
    public void entityJs$setSyncedData(String key, Object value) {
        EntityDataAccessor<?> accessor = this.entityJs$accessorMap.get(key);
        if (accessor == null) {
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Tried to set undefined synced data key: " + key);
            return;
        }
        EntityDataSerializer serializer = accessor.m_135016_();
        EntitySerializerType type = EntitySerializerType.fromSerializer(serializer);
        String castHint = switch (type.toString().toLowerCase()) {
            case "byte", "int", "float", "long" -> type.toString().toLowerCase();
            default -> null;
        };
        Object casted = EntitySerializerType.castValue(value, castHint);
        this.entityJs$getLivingEntity().m_20088_().m_135381_(accessor, casted);
    }

    @Override
    @Nullable
    public <T> T entityJs$getSyncedData(String identifier) {
        EntityDataAccessor<?> accessor = this.entityJs$accessorMap.get(identifier);
        if (accessor == null) {
            return null;
        }
        if (!this.entityJs$getLivingEntity().m_20088_().m_285897_(accessor)) {
            return null;
        }
        return (T)this.entityJs$getLivingEntity().m_20088_().m_135370_(accessor);
    }

    public void entityJs$defineSynchedData() {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.defineSyncedData != null) {
                builder.defineSyncedData.accept(this.entityJs$getLivingEntity());
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void entityjs$writeSyncedData(CompoundTag tag, CallbackInfo ci) {
        CompoundTag jsData = new CompoundTag();
        for (Map.Entry<String, EntityDataAccessor<?>> entry : this.entityJs$accessorMap.entrySet()) {
            String key = entry.getKey();
            EntityDataAccessor<?> accessor = entry.getValue();
            Object value = this.entityJs$getLivingEntity().m_20088_().m_135370_(accessor);
            EntityDataSerializer serializer = accessor.m_135016_();
            EntitySerializerType type = EntitySerializerType.fromSerializer(serializer);
            switch (type) {
                case UUID: {
                    jsData.m_128362_(key, (UUID)value);
                    break;
                }
                case BYTE: {
                    jsData.m_128344_(key, ((Byte)value).byteValue());
                    break;
                }
                case INT: {
                    jsData.m_128405_(key, ((Integer)value).intValue());
                    break;
                }
                case LONG: {
                    jsData.m_128356_(key, ((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    jsData.m_128350_(key, ((Float)value).floatValue());
                    break;
                }
                case STRING: {
                    jsData.m_128359_(key, (String)value);
                    break;
                }
                case BOOLEAN: {
                    jsData.m_128379_(key, ((Boolean)value).booleanValue());
                    break;
                }
                case COMPOUND_TAG: {
                    jsData.m_128365_(key, (Tag)((CompoundTag)value).m_6426_());
                    break;
                }
                case VECTOR3: {
                    CompoundTag vecTag = new CompoundTag();
                    Vector3f v = (Vector3f)value;
                    vecTag.m_128350_("x", v.x());
                    vecTag.m_128350_("y", v.y());
                    vecTag.m_128350_("z", v.z());
                    jsData.m_128365_(key, (Tag)vecTag);
                    break;
                }
                case QUATERNION: {
                    CompoundTag quatTag = new CompoundTag();
                    Quaternionf q = (Quaternionf)value;
                    quatTag.m_128350_("x", q.x());
                    quatTag.m_128350_("y", q.y());
                    quatTag.m_128350_("z", q.z());
                    quatTag.m_128350_("w", q.w());
                    jsData.m_128365_(key, (Tag)quatTag);
                }
            }
        }
        tag.m_128365_("EntityJSData", (Tag)jsData);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void entityjs$readSyncedData(CompoundTag tag, CallbackInfo ci) {
        if (!tag.m_128425_("EntityJSData", 10)) {
            return;
        }
        CompoundTag jsData = tag.m_128469_("EntityJSData");
        for (String key : jsData.m_128431_()) {
            if (!this.entityJs$accessorMap.containsKey(key)) continue;
            EntityDataAccessor<?> accessor = this.entityJs$accessorMap.get(key);
            EntityDataSerializer serializer = accessor.m_135016_();
            EntitySerializerType type = EntitySerializerType.fromSerializer(serializer);
            Object value = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EntitySerializerType.UUID -> jsData.m_128342_(key);
                case EntitySerializerType.BYTE -> jsData.m_128445_(key);
                case EntitySerializerType.INT -> jsData.m_128451_(key);
                case EntitySerializerType.LONG -> jsData.m_128454_(key);
                case EntitySerializerType.FLOAT -> Float.valueOf(jsData.m_128457_(key));
                case EntitySerializerType.STRING -> jsData.m_128461_(key);
                case EntitySerializerType.BOOLEAN -> jsData.m_128471_(key);
                case EntitySerializerType.COMPOUND_TAG -> jsData.m_128469_(key);
                case EntitySerializerType.VECTOR3 -> {
                    CompoundTag vecTag = jsData.m_128469_(key);
                    float x = vecTag.m_128457_("x");
                    float y = vecTag.m_128457_("y");
                    float z = vecTag.m_128457_("z");
                    yield new Vector3f(x, y, z);
                }
                case EntitySerializerType.QUATERNION -> {
                    CompoundTag quatTag = jsData.m_128469_(key);
                    float x = quatTag.m_128457_("x");
                    float y = quatTag.m_128457_("y");
                    float z = quatTag.m_128457_("z");
                    float w = quatTag.m_128457_("w");
                    yield new Quaternionf(x, y, z, w);
                }
            };
            this.entityJs$setSyncedData(key, value);
        }
    }

    public String entityJs$getTypeId() {
        return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.entityJs$getLivingEntity().m_6095_())).toString();
    }

    @Inject(method={"brainProvider"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void brainProvider(CallbackInfoReturnable<Brain.Provider<?>> cir) {
        if (EventHandlers.buildBrainProvider.hasListeners()) {
            BuildBrainProviderEventJS event = new BuildBrainProviderEventJS();
            EventHandlers.buildBrainProvider.post(event, (Object)this.entityJs$getTypeId());
            cir.setReturnValue(event.provide());
        }
    }

    @Inject(method={"makeBrain"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void makeBrain(Dynamic<?> pDynamic, CallbackInfoReturnable<Brain<?>> cir) {
        if (EventHandlers.buildBrain.hasListeners()) {
            Brain brain = (Brain)UtilsJS.cast((Object)this.entityJs$getLivingEntity().m_5490_().m_22073_(pDynamic));
            EventHandlers.buildBrain.post(new BuildBrainEventJS(brain), (Object)this.entityJs$getTypeId());
            cir.setReturnValue((Object)brain);
        }
    }

    @Inject(method={"getMobType"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getMobType(CallbackInfoReturnable<MobType> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (this.entityJs$builder != null && builder.mobType != null) {
                cir.setReturnValue((Object)builder.mobType);
            }
        }
    }

    @Inject(method={"tickDeath"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void tickDeath(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.tickDeath != null) {
                EntityJSHelperClass.consumerCallback(builder.tickDeath, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: tickDeath.");
            }
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$aiStep(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.aiStep != null) {
                builder.aiStep.accept(this.entityJs$getLivingEntity());
            }
        }
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$onHurtTarget(Entity pTarget, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (this.entityJs$builder != null && builder.onHurtTarget != null) {
                ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pTarget, (Entity)this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.onHurtTarget, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onHurtTarget.");
            }
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$travel(Vec3 pTravelVector, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.travel != null) {
                ContextUtils.Vec3Context context = new ContextUtils.Vec3Context(pTravelVector, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.travel, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: travel.");
            }
        }
    }

    @Inject(method={"doAutoAttackOnTouch"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$doAutoAttackOnTouch(LivingEntity pTarget, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.doAutoAttackOnTouch != null) {
                ContextUtils.AutoAttackContext context = new ContextUtils.AutoAttackContext(this.entityJs$getLivingEntity(), pTarget);
                EntityJSHelperClass.consumerCallback(builder.doAutoAttackOnTouch, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: doAutoAttackOnTouch.");
            }
        }
    }

    @Inject(method={"decreaseAirSupply"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$decreaseAirSupply(int pCurrentAir, CallbackInfoReturnable<Integer> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onDecreaseAirSupply != null) {
                EntityJSHelperClass.consumerCallback(builder.onDecreaseAirSupply, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onDecreaseAirSupply.");
            }
        }
    }

    @Inject(method={"increaseAirSupply"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$increaseAirSupply(int pCurrentAir, CallbackInfoReturnable<Integer> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onIncreaseAirSupply != null) {
                EntityJSHelperClass.consumerCallback(builder.onIncreaseAirSupply, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onIncreaseAirSupply.");
            }
        }
    }

    @Inject(method={"blockedByShield"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$blockedByShield(LivingEntity pDefender, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onBlockedByShield != null) {
                ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext(this.entityJs$getLivingEntity(), pDefender);
                EntityJSHelperClass.consumerCallback(builder.onBlockedByShield, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onDecreaseAirSupply.");
            }
        }
    }

    @Inject(method={"onEquipItem"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$onEquipItem(EquipmentSlot pSlot, ItemStack pOldItem, ItemStack pNewItem, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onEquipItem != null) {
                ContextUtils.EntityEquipmentContext context = new ContextUtils.EntityEquipmentContext(pSlot, pOldItem, pNewItem, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.onEquipItem, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onEquipItem.");
            }
        }
    }

    @Inject(method={"onEffectAdded"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$onEffectAdded(MobEffectInstance pEffectInstance, Entity pEntity, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onEffectAdded != null) {
                ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(pEffectInstance, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.onEffectAdded, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onEffectAdded.");
            }
        }
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$onEffectRemoved(MobEffectInstance pEffectInstance, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onEffectRemoved != null) {
                ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(pEffectInstance, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.onEffectRemoved, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onEffectRemoved.");
            }
        }
    }

    @Inject(method={"heal"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$heal(float pHealAmount, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onLivingHeal != null) {
                ContextUtils.EntityHealContext context = new ContextUtils.EntityHealContext(this.entityJs$getLivingEntity(), pHealAmount);
                EntityJSHelperClass.consumerCallback(builder.onLivingHeal, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onLivingHeal.");
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$die(DamageSource pDamageSource, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onDeath != null) {
                ContextUtils.DeathContext context = new ContextUtils.DeathContext(this.entityJs$getLivingEntity(), pDamageSource);
                EntityJSHelperClass.consumerCallback(builder.onDeath, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onDeath.");
            }
        }
    }

    @Inject(method={"dropCustomDeathLoot"}, at={@At(value="HEAD", ordinal=0)}, remap=true)
    private void entityjs$dropCustomDeathLoot(DamageSource pDamageSource, int pLooting, boolean pHitByPlayer, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.dropCustomDeathLoot != null) {
                ContextUtils.EntityLootContext context = new ContextUtils.EntityLootContext(pDamageSource, pLooting, pHitByPlayer, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.dropCustomDeathLoot, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: dropCustomDeathLoot.");
            }
        }
    }

    @Inject(method={"getSoundVolume"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getSoundVolume(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.setSoundVolume != null) {
                cir.setReturnValue((Object)builder.setSoundVolume);
            }
        }
    }

    @Inject(method={"getWaterSlowDown"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getWaterSlowDown(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.setWaterSlowDown != null) {
                cir.setReturnValue((Object)builder.setWaterSlowDown);
            }
        }
    }

    @Inject(method={"getStandingEyeHeight"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getStandingEyeHeight(Pose pPose, EntityDimensions pDimensions, CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.setStandingEyeHeight == null) {
                return;
            }
            ContextUtils.EntityPoseDimensionsContext context = new ContextUtils.EntityPoseDimensionsContext(pPose, pDimensions, this.entityJs$getLivingEntity());
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.setStandingEyeHeight.apply(context), "float");
            if (obj != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)obj).floatValue()));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setStandingEyeHeight from entity: " + this.entityJs$entityName() + ". Value: " + builder.setStandingEyeHeight.apply(context) + ". Must be a float. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"isPushable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isPushable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.isPushable != null) {
                cir.setReturnValue((Object)builder.isPushable);
            }
        }
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.blockSpeedFactor == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.blockSpeedFactor.apply(this.entityJs$getLivingEntity()), "float");
            if (obj != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)obj).floatValue()));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityJs$getLivingEntity().m_6095_() + ". Value: " + builder.blockSpeedFactor.apply(this.entityJs$getLivingEntity()) + ". Must be a float, defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"shouldDropLoot"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$shouldDropLoot(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.shouldDropLoot != null) {
                Object obj = builder.shouldDropLoot.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldDropLoot from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isAffectedByFluids"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isAffectedByFluids(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.isAffectedByFluids != null) {
                Object obj = builder.isAffectedByFluids.apply(this.entityJs$getLivingEntity());
                if (obj == null) {
                    return;
                }
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAffectedByFluids from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isAlwaysExperienceDropper"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isAlwaysExperienceDropper(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.isAlwaysExperienceDropper != null) {
                cir.setReturnValue((Object)builder.isAlwaysExperienceDropper);
            }
        }
    }

    @Inject(method={"isImmobile"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isImmobile(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.isImmobile != null) {
                Object obj = builder.isImmobile.apply(this.entityJs$getLivingEntity());
                if (obj == null) {
                    return;
                }
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isImmobile from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"calculateFallDamage"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$calculateFallDamage(float pFallDistance, float pDamageMultiplier, CallbackInfoReturnable<Integer> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.calculateFallDamage == null) {
                return;
            }
            ContextUtils.CalculateFallDamageContext context = new ContextUtils.CalculateFallDamageContext(pFallDistance, pDamageMultiplier, this.entityJs$getLivingEntity());
            Object func = builder.calculateFallDamage.apply(context);
            if (func == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(func, "integer");
            if (obj != null) {
                cir.setReturnValue((Object)((Integer)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for calculateFallDamage from entity: " + this.entityJs$entityName() + ". Value: " + func + ". Must be an int, defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getHurtSound(DamageSource pDamageSource, CallbackInfoReturnable<SoundEvent> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.setHurtSound == null) {
                return;
            }
            ContextUtils.HurtContext context = new ContextUtils.HurtContext(this.entityJs$getLivingEntity(), pDamageSource);
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.setHurtSound.apply(context), "resourcelocation");
            if (obj != null) {
                cir.setReturnValue((Object)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)obj)));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setHurtSound from entity: " + this.entityJs$entityName() + ". Value: " + builder.setHurtSound.apply(context) + ". Must be a ResourceLocation or String. Defaulting to \"minecraft:entity.generic.hurt\"");
            }
        }
    }

    @Inject(method={"canAttackType"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canAttackType(EntityType<?> pEntityType, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.canAttackType != null) {
                ContextUtils.EntityTypeEntityContext context = new ContextUtils.EntityTypeEntityContext(this.entityJs$getLivingEntity(), pEntityType);
                Object obj = builder.canAttackType.apply(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAttackType from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"getScale"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getScale(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.scale == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.scale.apply(this.entityJs$getLivingEntity()), "float");
            if (obj != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)obj).floatValue()));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for scale from entity: " + this.entityJs$entityName() + ". Value: " + builder.scale.apply(this.entityJs$getLivingEntity()) + ". Must be a float. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"shouldDropExperience"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$shouldDropExperience(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.shouldDropExperience != null) {
                Object obj = builder.shouldDropExperience.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldDropExperience from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"getVisibilityPercent"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getVisibilityPercent(Entity pLookingEntity, CallbackInfoReturnable<Double> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.visibilityPercent != null) {
                ContextUtils.VisualContext context = new ContextUtils.VisualContext(pLookingEntity, this.entityJs$getLivingEntity());
                Object obj = EntityJSHelperClass.convertObjectToDesired(builder.visibilityPercent.apply(context), "double");
                if (obj != null) {
                    cir.setReturnValue((Object)((Double)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for visibilityPercent from entity: " + this.entityJs$entityName() + ". Value: " + builder.visibilityPercent.apply(context) + ". Must be a double. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canAttack(LivingEntity pTarget, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.canAttack != null) {
                ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext(this.entityJs$getLivingEntity(), pTarget);
                Object obj = builder.canAttack.apply(context);
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    boolean bool = b;
                    cir.setReturnValue((Object)bool);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAttack from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canBeAffected(MobEffectInstance pEffectInstance, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.canBeAffected == null) {
                return;
            }
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(pEffectInstance, this.entityJs$getLivingEntity());
            Object result = builder.canBeAffected.apply(context);
            if (result instanceof Boolean) {
                cir.setReturnValue((Object)((Boolean)result));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeAffected from entity: " + this.entityJs$entityName() + ". Value: " + result + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"isInvertedHealAndHarm"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isInvertedHealAndHarm(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.invertedHealAndHarm == null) {
                return;
            }
            Object obj = builder.invertedHealAndHarm.apply(this.entityJs$getLivingEntity());
            if (obj instanceof Boolean) {
                cir.setReturnValue((Object)((Boolean)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for invertedHealAndHarm from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.setDeathSound == null) {
                return;
            }
            cir.setReturnValue((Object)Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)builder.setDeathSound)));
        }
    }

    @Inject(method={"getFallSounds"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getFallSounds(CallbackInfoReturnable<LivingEntity.Fallsounds> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.fallSounds != null) {
                cir.setReturnValue((Object)new LivingEntity.Fallsounds(Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)builder.smallFallSound)), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)builder.largeFallSound))));
            }
        }
    }

    @Inject(method={"getEatingSound"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getEatingSound(ItemStack pStack, CallbackInfoReturnable<SoundEvent> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.eatingSound != null) {
                cir.setReturnValue((Object)Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)builder.eatingSound)));
            }
        }
    }

    @Inject(method={"onClimbable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$onClimbable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onClimbable == null) {
                return;
            }
            Object obj = builder.onClimbable.apply(this.entityJs$getLivingEntity());
            if (obj instanceof Boolean) {
                cir.setReturnValue((Object)((Boolean)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for onClimbable from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to super.onClimbable(): " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"canBreatheUnderwater"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canBreatheUnderwater(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.canBreatheUnderwater != null) {
                cir.setReturnValue((Object)builder.canBreatheUnderwater);
            }
        }
    }

    @Inject(method={"getJumpBoostPower"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getJumpBoostPower(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.jumpBoostPower == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.jumpBoostPower.apply(this.entityJs$getLivingEntity()), "float");
            if (obj != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)obj).floatValue()));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for jumpBoostPower from entity: " + this.entityJs$entityName() + ". Value: " + builder.jumpBoostPower.apply(this.entityJs$getLivingEntity()) + ". Must be a float. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canStandOnFluid(FluidState pFluidState, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.canStandOnFluid != null) {
                ContextUtils.EntityFluidStateContext context = new ContextUtils.EntityFluidStateContext(this.entityJs$getLivingEntity(), pFluidState);
                Object obj = EntityJSHelperClass.convertObjectToDesired(builder.canStandOnFluid.apply(context), "boolean");
                if (obj != null) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canStandOnFluid from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"isSensitiveToWater"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.isSensitiveToWater != null) {
                Object obj = EntityJSHelperClass.convertObjectToDesired(builder.isSensitiveToWater.apply(this.entityJs$getLivingEntity()), "boolean");
                if (obj != null) {
                    cir.setReturnValue((Object)((Boolean)obj));
                    return;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSensitiveToWater from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"onItemPickup"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$onItemPickup(ItemEntity pItemEntity, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onItemPickup != null) {
                ContextUtils.EntityItemEntityContext context = new ContextUtils.EntityItemEntityContext(this.entityJs$getLivingEntity(), pItemEntity);
                EntityJSHelperClass.consumerCallback(builder.onItemPickup, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onItemPickup.");
            }
        }
    }

    @Inject(method={"hasLineOfSight"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$hasLineOfSight(Entity pEntity, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.hasLineOfSight != null) {
                ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (Entity)this.entityJs$getLivingEntity());
                Object obj = builder.hasLineOfSight.apply(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for hasLineOfSight from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"onEnterCombat"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$onEnterCombat(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onEnterCombat != null) {
                EntityJSHelperClass.consumerCallback(builder.onEnterCombat, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onEnterCombat.");
            }
        }
    }

    @Inject(method={"onLeaveCombat"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$onLeaveCombat(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onLeaveCombat != null) {
                EntityJSHelperClass.consumerCallback(builder.onLeaveCombat, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onLeaveCombat.");
            }
        }
    }

    @Inject(method={"isAffectedByPotions"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isAffectedByPotions(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.isAffectedByPotions != null) {
                Object obj = builder.isAffectedByPotions.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAffectedByPotions from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"attackable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$attackable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.isAttackableFunction != null) {
                Object obj = builder.isAttackableFunction.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isSleeping"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isSleeping(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (this.entityJs$builder != null && builder.isSleeping != null) {
                Object obj = builder.isSleeping.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSleeping from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"startSleeping"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$startSleeping(BlockPos pPos, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onStartSleeping != null) {
                ContextUtils.EntityBlockPosContext context = new ContextUtils.EntityBlockPosContext(this.entityJs$getLivingEntity(), pPos);
                EntityJSHelperClass.consumerCallback(builder.onStartSleeping, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onStartSleeping.");
            }
        }
    }

    @Inject(method={"stopSleeping"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$stopSleeping(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onStopSleeping != null) {
                EntityJSHelperClass.consumerCallback(builder.onStopSleeping, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onStopSleeping.");
            }
        }
    }

    @Inject(method={"eat"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$eat(Level pLevel, ItemStack pFood, CallbackInfoReturnable<ItemStack> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.eat != null) {
                ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext(this.entityJs$getLivingEntity(), pFood, pLevel);
                EntityJSHelperClass.consumerCallback(builder.eat, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: eat.");
            }
        }
    }

    @Inject(method={"shouldRiderFaceForward"}, at={@At(value="HEAD", ordinal=0)}, remap=false, cancellable=true)
    private void entityjs$shouldRiderFaceForward(Player player, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.shouldRiderFaceForward != null) {
                ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(player, this.entityJs$getLivingEntity());
                Object obj = builder.shouldRiderFaceForward.apply(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldRiderFaceForward from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canFreeze(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.canFreeze != null) {
                Object obj = builder.canFreeze.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isCurrentlyGlowing"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$isCurrentlyGlowing(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (this.entityJs$builder != null && builder.isCurrentlyGlowing != null && !this.entityJs$getLivingEntity().m_9236_().m_5776_()) {
                Object obj = builder.isCurrentlyGlowing.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"canDisableShield"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canDisableShield(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.canDisableShield != null) {
                Object obj = builder.canDisableShield.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canDisableShield from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$actuallyHurt(DamageSource pDamageSource, float pDamageAmount, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.onHurt != null) {
                ContextUtils.EntityDamageContext context = new ContextUtils.EntityDamageContext(pDamageSource, pDamageAmount, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.onHurt, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onHurt.");
            }
        }
    }

    @Inject(method={"getExperienceReward"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$getExperienceReward(CallbackInfoReturnable<Integer> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.experienceReward != null) {
                Object obj = EntityJSHelperClass.convertObjectToDesired(builder.experienceReward.apply(this.entityJs$getLivingEntity()), "integer");
                if (obj != null) {
                    cir.setReturnValue((Object)((Integer)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for experienceReward from entity: " + this.entityJs$entityName() + ". Value: " + builder.experienceReward.apply(this.entityJs$getLivingEntity()) + ". Must be an integer. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"canChangeDimensions"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canChangeDimensions(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.canChangeDimensions != null) {
                Object obj = builder.canChangeDimensions.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"lerpTo"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$lerpTo(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            ModifyLivingEntityBuilder builder = (ModifyLivingEntityBuilder)((Object)object);
            if (builder.lerpTo != null) {
                ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(pX, pY, pZ, pYaw, pPitch, pPosRotationIncrements, pTeleport, (Entity)this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.lerpTo, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: lerpTo.");
            }
        }
    }
}

