/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.nonliving.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.client.nonliving.KubeJSNLEntityRenderer;
import net.liopyu.entityjs.client.nonliving.model.NLGeoLayerJSBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class NLGeoLayerJS<T extends Entity>
extends GeoRenderLayer<T> {
    public T entity;
    public final NLGeoLayerJSBuilder<T> geoBuilder;
    public final KubeJSNLEntityRenderer<T> renderer;
    public final BaseEntityBuilder<T> builder;

    public NLGeoLayerJS(KubeJSNLEntityRenderer<T> entityRendererIn, NLGeoLayerJSBuilder<T> geoBuilder, BaseEntityBuilder<T> builder) {
        super(entityRendererIn);
        this.geoBuilder = geoBuilder;
        this.renderer = entityRendererIn;
        this.builder = builder;
    }

    public String entityName() {
        return ((EntityType)this.builder.get()).toString();
    }

    protected ResourceLocation getTextureResource(T animatable) {
        if (this.geoBuilder.textureResource != null) {
            Object obj = this.geoBuilder.textureResource.apply(animatable);
            if (obj instanceof ResourceLocation) {
                ResourceLocation r = (ResourceLocation)obj;
                return r;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for textureResource in newGeoLayer builder. Value: " + obj + ". Must be a ResourceLocation. Defaulting to " + super.getTextureResource(animatable));
        }
        return super.getTextureResource(animatable);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (this.geoBuilder.preRender != null && animatable != null) {
            ContextUtils.PreRenderContext<T> context = new ContextUtils.PreRenderContext<T>(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.geoBuilder.preRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: preRender");
            super.preRender(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        } else {
            super.preRender(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTicks, int packedLightIn, int packedOverlay) {
        if (this.geoBuilder.render != null && animatable != null) {
            ContextUtils.PreRenderContext<T> context = new ContextUtils.PreRenderContext<T>(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTicks, packedLightIn, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.geoBuilder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render");
            RenderType renderLayer = RenderType.m_110458_((ResourceLocation)this.getTextureResource(animatable));
            this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, animatable, renderLayer, bufferSource.m_6299_(renderLayer), partialTicks, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderType renderLayer = RenderType.m_110458_((ResourceLocation)this.getTextureResource(animatable));
            this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, animatable, renderLayer, bufferSource.m_6299_(renderLayer), partialTicks, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

