/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.client.living.model.CustomEntityModelJS;
import net.liopyu.entityjs.client.living.model.CustomGeoLayerJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJSCustom;
import net.liopyu.entityjs.entities.living.entityjs.WrappedAnimatableEntity;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.implementation.ILivingEntityJS;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtils;

public class CustomKubeJSEntityRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    private final CustomEntityJSBuilder builder;

    public CustomKubeJSEntityRenderer(EntityRendererProvider.Context renderManager, CustomEntityJSBuilder builder) {
        super(renderManager, new CustomEntityModelJS(builder));
        Object layerPart;
        this.builder = builder;
        this.scaleHeight = this.getScaleHeight();
        this.scaleWidth = this.getScaleWidth();
        for (CustomGeoLayerJSBuilder<? extends LivingEntity> geoBuilder : builder.layerList) {
            layerPart = geoBuilder.build(this, builder);
            this.addRenderLayer((GeoRenderLayer)layerPart);
        }
        for (CustomGeoLayerJSBuilder<? extends LivingEntity> geoBuilder : builder.glowingLayerList) {
            layerPart = geoBuilder.buildGlowing(this, builder);
            this.addRenderLayer((GeoRenderLayer)layerPart);
        }
    }

    public String entityName() {
        return ((LivingEntity)this.animatable).m_6095_().toString();
    }

    public float getScaleHeight() {
        return this.builder.scaleHeight;
    }

    public float getScaleWidth() {
        return this.builder.scaleWidth;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, T a, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        Object animatable = a;
        if (animatable instanceof WrappedAnimatableEntity) {
            WrappedAnimatableEntity wrappedAnimatableEntity = (WrappedAnimatableEntity)animatable;
            animatable = wrappedAnimatableEntity.getOriginalEntity();
        }
        if (this.builder.scaleModelForRender != null && this.animatable != null) {
            ContextUtils.ScaleModelRenderContext context = new ContextUtils.ScaleModelRenderContext(widthScale, heightScale, poseStack, (LivingEntity)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.builder.scaleModelForRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: scaleModelForRender.");
            super.scaleModelForRender(widthScale, heightScale, poseStack, this.ensureIAnimatableJS((LivingEntity)animatable), model, isReRender, partialTick, packedLight, packedOverlay);
        } else {
            super.scaleModelForRender(widthScale, heightScale, poseStack, this.ensureIAnimatableJS((LivingEntity)animatable), model, isReRender, partialTick, packedLight, packedOverlay);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return (ResourceLocation)this.builder.textureResource.apply((LivingEntity)entity);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        try {
            if (this.builder.renderTypeFunction != null) {
                return this.builder.renderTypeFunction.apply((LivingEntity)this.ensureIAnimatableJS((LivingEntity)animatable));
            }
        }
        catch (Exception e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityName() + "builder for field: renderType.", e);
        }
        return switch (((IAnimatableJSCustom)this.ensureIAnimatableJS(animatable)).getBuilder().renderType) {
            default -> throw new IncompatibleClassChangeError();
            case CustomEntityJSBuilder.RenderType.SOLID -> RenderType.m_110446_((ResourceLocation)texture);
            case CustomEntityJSBuilder.RenderType.CUTOUT -> RenderType.m_110452_((ResourceLocation)texture);
            case CustomEntityJSBuilder.RenderType.TRANSLUCENT -> RenderType.m_110473_((ResourceLocation)texture);
        };
    }

    public void render(T a, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Object animatable = a;
        if (animatable instanceof WrappedAnimatableEntity) {
            WrappedAnimatableEntity wrappedAnimatableEntity = (WrappedAnimatableEntity)animatable;
            animatable = wrappedAnimatableEntity.getOriginalEntity();
        }
        if (this.builder.render != null && this.animatable != null) {
            ContextUtils.RenderContextCustom<T> context = new ContextUtils.RenderContextCustom<T>(this.ensureIAnimatableJS((LivingEntity)animatable), entityYaw, partialTick, poseStack, bufferSource, packedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render.");
            super.m_7392_(this.ensureIAnimatableJS((LivingEntity)animatable), entityYaw, partialTick, poseStack, bufferSource, packedLight);
        } else {
            super.m_7392_(this.ensureIAnimatableJS((LivingEntity)animatable), entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    protected void applyRotations(T a, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        Object animatable = a;
        if (animatable instanceof WrappedAnimatableEntity) {
            WrappedAnimatableEntity wrappedAnimatableEntity = (WrappedAnimatableEntity)animatable;
            animatable = wrappedAnimatableEntity.getOriginalEntity();
        }
        Pose pose = animatable.m_20089_();
        if (this.isShaking((Entity)this.ensureIAnimatableJS((LivingEntity)animatable))) {
            rotationYaw += (float)(Math.cos((double)((LivingEntity)animatable).f_19797_ * 3.25) * Math.PI * 0.4);
        }
        if (pose != Pose.SLEEPING) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
        }
        if (((LivingEntity)animatable).f_20919_ > 0 && this.builder.defaultDeathPose.booleanValue()) {
            float deathRotation = ((float)((LivingEntity)animatable).f_20919_ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Math.min(Mth.m_14116_((float)deathRotation), 1.0f) * this.getDeathMaxRotation((Entity)this.ensureIAnimatableJS((LivingEntity)animatable))));
        } else if (animatable.m_21209_()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - animatable.m_146909_()));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)((LivingEntity)animatable).f_19797_ + partialTick) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction bedOrientation = animatable.m_21259_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(bedOrientation != null ? RenderUtils.getDirectionAngle((Direction)bedOrientation) : rotationYaw));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(this.getDeathMaxRotation((Entity)this.ensureIAnimatableJS((LivingEntity)animatable))));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (animatable.m_8077_() || animatable instanceof Player) {
            String name = animatable.m_7755_().getString();
            if (animatable instanceof Player) {
                Player player = (Player)animatable;
                if (!player.m_36170_(PlayerModelPart.CAPE)) {
                    return;
                }
            } else {
                name = ChatFormatting.m_126649_((String)name);
            }
            if (name != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
                poseStack.m_252880_(0.0f, animatable.m_20206_() + 0.1f, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            }
            if (name != null && (name.equalsIgnoreCase("liopyu") || name.equalsIgnoreCase("toomuchmail"))) {
                poseStack.m_252880_(0.0f, animatable.m_20206_() + 0.1f, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
        }
    }

    private T ensureIAnimatableJS(LivingEntity entity) {
        if (entity instanceof IAnimatableJSCustom) {
            IAnimatableJSCustom animatableJS = (IAnimatableJSCustom)entity;
            return (T)((LivingEntity)animatableJS);
        }
        if (entity instanceof ILivingEntityJS) {
            ILivingEntityJS iLivingEntityJS = (ILivingEntityJS)entity;
            return (T)iLivingEntityJS.entityJs$getAnimatableEntity();
        }
        return (T)new WrappedAnimatableEntity(entity, this.builder);
    }
}

