/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.optim;

import com.happysg.radar.math3.exception.TooManyEvaluationsException;
import com.happysg.radar.math3.exception.TooManyIterationsException;
import com.happysg.radar.math3.optim.ConvergenceChecker;
import com.happysg.radar.math3.optim.OptimizationProblem;
import com.happysg.radar.math3.util.Incrementor;

public abstract class AbstractOptimizationProblem<PAIR>
implements OptimizationProblem<PAIR> {
    private static final MaxEvalCallback MAX_EVAL_CALLBACK = new MaxEvalCallback();
    private static final MaxIterCallback MAX_ITER_CALLBACK = new MaxIterCallback();
    private final int maxEvaluations;
    private final int maxIterations;
    private final ConvergenceChecker<PAIR> checker;

    protected AbstractOptimizationProblem(int maxEvaluations, int maxIterations, ConvergenceChecker<PAIR> checker) {
        this.maxEvaluations = maxEvaluations;
        this.maxIterations = maxIterations;
        this.checker = checker;
    }

    @Override
    public Incrementor getEvaluationCounter() {
        return new Incrementor(this.maxEvaluations, MAX_EVAL_CALLBACK);
    }

    @Override
    public Incrementor getIterationCounter() {
        return new Incrementor(this.maxIterations, MAX_ITER_CALLBACK);
    }

    @Override
    public ConvergenceChecker<PAIR> getConvergenceChecker() {
        return this.checker;
    }

    private static class MaxEvalCallback
    implements Incrementor.MaxCountExceededCallback {
        private MaxEvalCallback() {
        }

        @Override
        public void trigger(int max) {
            throw new TooManyEvaluationsException(max);
        }
    }

    private static class MaxIterCallback
    implements Incrementor.MaxCountExceededCallback {
        private MaxIterCallback() {
        }

        @Override
        public void trigger(int max) {
            throw new TooManyIterationsException(max);
        }
    }
}

