/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.ode;

import com.happysg.radar.math3.ode.Parameterizable;
import com.happysg.radar.math3.ode.UnknownParameterException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractParameterizable
implements Parameterizable {
    private final Collection<String> parametersNames = new ArrayList<String>();

    protected AbstractParameterizable(String ... names) {
        for (String name : names) {
            this.parametersNames.add(name);
        }
    }

    protected AbstractParameterizable(Collection<String> names) {
        this.parametersNames.addAll(names);
    }

    @Override
    public Collection<String> getParametersNames() {
        return this.parametersNames;
    }

    @Override
    public boolean isSupported(String name) {
        for (String supportedName : this.parametersNames) {
            if (!supportedName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void complainIfNotSupported(String name) throws UnknownParameterException {
        if (!this.isSupported(name)) {
            throw new UnknownParameterException(name);
        }
    }
}

