/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.ml.neuralnet.twod.util;

import com.happysg.radar.math3.ml.distance.DistanceMeasure;
import com.happysg.radar.math3.ml.neuralnet.MapUtils;
import com.happysg.radar.math3.ml.neuralnet.Neuron;
import com.happysg.radar.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import com.happysg.radar.math3.ml.neuralnet.twod.util.LocationFinder;
import com.happysg.radar.math3.ml.neuralnet.twod.util.MapDataVisualization;

public class QuantizationError
implements MapDataVisualization {
    private final DistanceMeasure distance;

    public QuantizationError(DistanceMeasure distance) {
        this.distance = distance;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D map, Iterable<double[]> data) {
        int nR = map.getNumberOfRows();
        int nC = map.getNumberOfColumns();
        LocationFinder finder = new LocationFinder(map);
        int[][] hit = new int[nR][nC];
        double[][] error = new double[nR][nC];
        for (double[] sample : data) {
            Neuron best = MapUtils.findBest(sample, map, this.distance);
            LocationFinder.Location loc = finder.getLocation(best);
            int row = loc.getRow();
            int col = loc.getColumn();
            int[] nArray = hit[row];
            int n = col;
            nArray[n] = nArray[n] + 1;
            double[] dArray = error[row];
            int n2 = col;
            dArray[n2] = dArray[n2] + this.distance.compute(sample, best.getFeatures());
        }
        for (int r = 0; r < nR; ++r) {
            for (int c = 0; c < nC; ++c) {
                int count = hit[r][c];
                if (count == 0) continue;
                double[] dArray = error[r];
                int n = c;
                dArray[n] = dArray[n] / (double)count;
            }
        }
        return error;
    }
}

