/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.cbc;

import com.happysg.radar.compat.cbc.CannonUtil;
import com.happysg.radar.compat.vs2.VS2Utils;
import com.happysg.radar.math3.analysis.MultivariateFunction;
import com.happysg.radar.math3.optim.InitialGuess;
import com.happysg.radar.math3.optim.MaxEval;
import com.happysg.radar.math3.optim.PointValuePair;
import com.happysg.radar.math3.optim.SimpleBounds;
import com.happysg.radar.math3.optim.nonlinear.scalar.GoalType;
import com.happysg.radar.math3.optim.nonlinear.scalar.MultiStartMultivariateOptimizer;
import com.happysg.radar.math3.optim.nonlinear.scalar.ObjectiveFunction;
import com.happysg.radar.math3.optim.nonlinear.scalar.noderiv.BOBYQAOptimizer;
import com.happysg.radar.math3.random.RandomVectorGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4dc;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.ships.Ship;

public class VS2TargetingSolver {
    private final double u;
    private final double drag;
    private final Vec3 targetPos;
    private final Vec3 mountPos;
    private final double g;
    private final Level level;
    double initialTheta;
    double initialZeta;
    double initialPsi;
    double l;
    Matrix4dc shipToWorld;
    Matrix4dc worldToShip;
    private static final double TOLERANCE = 0.001;
    RandomVectorGenerator randomVectorGenerator = new RandomVectorGenerator(){
        private final Random random = new Random();

        @Override
        public double[] nextVector() {
            double thetaLower = -90.0;
            double thetaUpper = 90.0;
            double zetaLower = 0.0;
            double zetaUpper = 360.0;
            double theta = thetaLower + this.random.nextDouble() * (thetaUpper - thetaLower);
            double zeta = zetaLower + this.random.nextDouble() * (zetaUpper - zetaLower);
            return new double[]{theta, zeta};
        }
    };

    public VS2TargetingSolver(Level level, double u, double drag, double g, double barrelLength, Vec3 mountPos, Vec3 targetPos, double initialTheta, double initialZeta, double initialPsi, Ship ship) {
        this.level = level;
        this.u = u;
        this.drag = drag;
        this.g = Math.abs(g);
        this.initialTheta = initialTheta;
        this.initialZeta = initialZeta;
        this.initialPsi = initialPsi;
        this.shipToWorld = ship.getShipToWorld();
        this.worldToShip = ship.getWorldToShip();
        this.targetPos = targetPos;
        this.mountPos = mountPos;
        this.l = barrelLength;
    }

    private MultivariateFunction createFunction() {
        return point -> {
            double theta = point[0];
            double zeta = point[1];
            double thetaRad = Math.toRadians(theta);
            double zetaRad = Math.toRadians(zeta);
            Vec3 pivotPoint = this.mountPos;
            Vec3 shipyardFrontOfBarrel = this.mountPos.m_82520_(Math.cos(zetaRad + 1.5707963267948966) * Math.cos(thetaRad) * this.l, Math.sin(thetaRad) * this.l, Math.sin(zetaRad + 1.5707963267948966) * Math.cos(thetaRad) * this.l);
            Vec3 offset = CannonUtil.getCannonMountOffset(this.level, VS2Utils.getBlockPosFromVec3(this.mountPos));
            pivotPoint.m_82549_(offset);
            shipyardFrontOfBarrel.m_82549_(offset);
            Vec3 frontOfBarrel = VS2Utils.getVec3FromVector(this.shipToWorld.transformPosition(VS2Utils.getVector3dFromVec3(shipyardFrontOfBarrel)));
            pivotPoint = VS2Utils.getVec3FromVector(this.shipToWorld.transformPosition(VS2Utils.getVector3dFromVec3(pivotPoint)));
            Vec3 diffVec = this.targetPos.m_82546_(frontOfBarrel);
            double dZ = diffVec.f_82481_;
            double dY = diffVec.f_82480_ + 1.0;
            double dX = diffVec.f_82479_;
            Vector3f pivotVector = frontOfBarrel.m_82546_(pivotPoint).m_252839_();
            pivotVector = pivotVector.normalize();
            double pitch = Math.asin(pivotVector.y);
            double yaw = Math.atan2(pivotVector.z, pivotVector.x);
            if (yaw < 0.0) {
                yaw += Math.PI * 2;
            }
            thetaRad = Double.isNaN(pitch) ? 0.0 : pitch;
            zetaRad = Double.isNaN(yaw) ? 0.0 : yaw;
            double log = 1.0 - this.drag * dZ / (this.u * Math.cos(thetaRad) * Math.sin(zetaRad));
            if (log <= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            double time = Math.log(log) / -this.drag;
            if (time <= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            double dragDecay = 1.0 - Math.exp(-this.drag * time);
            double newX = this.u * Math.cos(thetaRad) * Math.cos(zetaRad) * dragDecay / this.drag;
            double newY = (this.drag * this.u * Math.sin(thetaRad) + this.g) * dragDecay / (this.drag * this.drag) - this.g * time / this.drag;
            return Math.abs(dY - newY) + Math.abs(dX - newX);
        };
    }

    public List<List<Double>> solveThetaZeta() {
        int numStarts = 2;
        MultiStartMultivariateOptimizer optimizer = new MultiStartMultivariateOptimizer(new BOBYQAOptimizer(5), numStarts, this.randomVectorGenerator);
        double[] lowerBounds = new double[]{-90.0, 0.0};
        double[] upperBounds = new double[]{90.0, 360.0};
        try {
            optimizer.optimize(new MaxEval(1000), new ObjectiveFunction(this.createFunction()), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0, 0.0}), new SimpleBounds(lowerBounds, upperBounds));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PointValuePair[] optima = optimizer.getOptima();
        ArrayList<List<Double>> results = new ArrayList<List<Double>>();
        HashSet<String> uniqueSolutions = new HashSet<String>();
        for (PointValuePair opt : optima) {
            double error;
            if (opt == null || !((error = ((Double)opt.getValue()).doubleValue()) < 0.001)) continue;
            double[] point = opt.getPoint();
            double theta = point[0];
            double zeta = point[1];
            String key = String.format("%d_%d", (int)Math.floor(theta), (int)Math.floor(zeta));
            if (uniqueSolutions.contains(key)) continue;
            uniqueSolutions.add(key);
            ArrayList<Double> pair = new ArrayList<Double>();
            pair.add(theta);
            pair.add(zeta);
            results.add(pair);
        }
        return results;
    }
}

