/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.plane;

import com.happysg.radar.block.radar.behavior.IRadar;
import com.happysg.radar.block.radar.behavior.RadarScanningBlockBehavior;
import com.happysg.radar.block.radar.plane.PlaneRadarBlock;
import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.compat.Mods;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PlaneRadarBlockEntity
extends SmartBlockEntity
implements IRadar {
    private RadarScanningBlockBehavior scanningBehavior;

    public PlaneRadarBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        if (!Mods.VALKYRIENSKIES.isLoaded()) {
            return;
        }
        this.scanningBehavior.setScanPos(PhysicsHandler.getWorldVec((BlockEntity)this));
        this.scanningBehavior.setRunning(true);
    }

    @Override
    public BlockPos getWorldPos() {
        return this.m_58899_();
    }

    public void tick() {
        super.tick();
        if (!Mods.VALKYRIENSKIES.isLoaded()) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)PlaneRadarBlock.f_54117_);
        Vec3 facingVec = new Vec3((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_());
        Vec3 shipVec = PhysicsHandler.getWorldVecDirectionTransform(facingVec, (BlockEntity)this);
        double angle = Math.toDegrees(Math.atan2(shipVec.f_82479_, shipVec.f_82481_));
        this.scanningBehavior.setAngle((angle + 360.0) % 360.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.scanningBehavior = new RadarScanningBlockBehavior(this);
        this.scanningBehavior.setRunning(true);
        this.scanningBehavior.setRange(250.0);
        this.scanningBehavior.setAngle((((Direction)this.m_58900_().m_61143_((Property)PlaneRadarBlock.f_54117_)).m_122435_() + 360.0f) % 360.0f);
        this.scanningBehavior.setScanPos(PhysicsHandler.getWorldVec((BlockEntity)this));
        this.scanningBehavior.setTrackExpiration(1);
        behaviours.add(this.scanningBehavior);
    }

    @Override
    public Collection<RadarTrack> getTracks() {
        return this.scanningBehavior.getRadarTracks();
    }

    @Override
    public float getRange() {
        return 250.0f;
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public float getGlobalAngle() {
        return 0.0f;
    }

    @Override
    public boolean renderRelativeToMonitor() {
        return false;
    }
}

