/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.bearing;

import com.happysg.radar.block.datalink.DataLinkBlock;
import com.happysg.radar.block.radar.receiver.AbstractRadarFrame;
import com.happysg.radar.block.radar.receiver.RadarReceiverBlock;
import com.happysg.radar.registry.ModBlocks;
import com.happysg.radar.registry.ModContraptionTypes;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.Pair;

public class RadarContraption
extends BearingContraption {
    private int dishCount;
    private boolean hasReceiver;
    private boolean creative;
    private Direction receiverFacing;

    public RadarContraption() {
        this.facing = Direction.UP;
    }

    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        boolean assembled = super.assemble(world, pos);
        if (!this.hasReceiver()) {
            throw new AssemblyException((Component)Component.m_237115_((String)"create_radar.radar.no_receiver"));
        }
        return assembled;
    }

    public void addBlock(Level level, BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture) {
        if (((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_().m_60734_() instanceof DataLinkBlock) {
            return;
        }
        if (((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_().m_60734_() instanceof DisplayLinkBlock) {
            return;
        }
        super.addBlock(level, pos, capture);
        if (ModBlocks.CREATIVE_RADAR_PLATE_BLOCK.has(((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_())) {
            this.creative = true;
        }
        if (((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_().m_60734_() instanceof AbstractRadarFrame) {
            ++this.dishCount;
        }
        if (((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_().m_60734_() instanceof RadarReceiverBlock) {
            this.hasReceiver = true;
            this.receiverFacing = (Direction)((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_().m_61143_((Property)RadarReceiverBlock.f_52588_);
        }
    }

    public int getDishCount() {
        return this.dishCount;
    }

    public boolean hasReceiver() {
        return this.hasReceiver;
    }

    public Direction getReceiverFacing() {
        return this.receiverFacing;
    }

    public boolean isCreative() {
        return this.creative;
    }

    public ContraptionType getType() {
        return ModContraptionTypes.RADAR_BEARING;
    }
}

