/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.monitor;

import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.block.radar.track.TrackCategory;
import com.happysg.radar.config.RadarConfig;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public record MonitorFilter(boolean player, boolean vs2, boolean contraption, boolean mob, boolean projectile, boolean animal, boolean item, List<String> blacklistPlayers, List<String> whitelistPlayers, List<String> blacklistVS2, List<String> whitelistVS) {
    public static final MonitorFilter DEFAULT = new MonitorFilter(true, true, true, true, true, true, true);

    public MonitorFilter(boolean player, boolean vs2, boolean contraption, boolean mob, boolean projectile, boolean animal, boolean item) {
        this(player, vs2, contraption, mob, projectile, animal, item, List.of(), List.of(), List.of(), List.of());
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("player", this.player);
        tag.m_128379_("vs2", this.vs2);
        tag.m_128379_("contraption", this.contraption);
        tag.m_128379_("mob", this.mob);
        tag.m_128379_("projectile", this.projectile);
        tag.m_128379_("animal", this.animal);
        tag.m_128379_("item", this.item);
        CompoundTag playersListTag = new CompoundTag();
        this.blacklistPlayers.forEach(player -> playersListTag.m_128379_(player, false));
        this.whitelistPlayers.forEach(player -> playersListTag.m_128379_(player, true));
        tag.m_128365_("playerList", (Tag)playersListTag);
        CompoundTag vs2ListTag = new CompoundTag();
        this.blacklistVS2.forEach(vs2 -> vs2ListTag.m_128379_(vs2, false));
        this.whitelistVS.forEach(vs2 -> vs2ListTag.m_128379_(vs2, true));
        tag.m_128365_("vs2Ships", (Tag)vs2ListTag);
        return tag;
    }

    public static MonitorFilter fromTag(CompoundTag tag) {
        boolean player = tag.m_128471_("player");
        boolean vs2 = tag.m_128471_("vs2");
        boolean contraption = tag.m_128471_("contraption");
        boolean mob = tag.m_128471_("mob");
        boolean projectile = tag.m_128471_("projectile");
        boolean animal = tag.m_128471_("animal");
        boolean item = tag.m_128471_("item");
        List<String> blacklistPlayers = tag.m_128469_("playerList").m_128431_().stream().filter(key -> !tag.m_128469_("playerList").m_128471_(key)).toList();
        List<String> whitelistPlayers = tag.m_128469_("playerList").m_128431_().stream().filter(key -> tag.m_128469_("playerList").m_128471_(key)).toList();
        List<String> blacklistVS2 = tag.m_128469_("vs2Ships").m_128431_().stream().filter(key -> !tag.m_128469_("vs2Ships").m_128471_(key)).toList();
        List<String> whitelistVS = tag.m_128469_("vs2Ships").m_128431_().stream().filter(key -> tag.m_128469_("vs2Ships").m_128471_(key)).toList();
        return new MonitorFilter(player, vs2, contraption, mob, projectile, animal, item, blacklistPlayers, whitelistPlayers, blacklistVS2, whitelistVS);
    }

    public boolean test(RadarTrack track) {
        return this.test(track.trackCategory());
    }

    public Color getColor(RadarTrack track) {
        if (track.trackCategory() == TrackCategory.PLAYER) {
            if (this.blacklistPlayers.contains(track.id())) {
                return new Color(((Integer)RadarConfig.client().hostileColor.get()).intValue());
            }
            if (this.whitelistPlayers.contains(track.id())) {
                return new Color(((Integer)RadarConfig.client().friendlyColor.get()).intValue());
            }
        }
        if (track.trackCategory() == TrackCategory.VS2) {
            if (this.blacklistVS2.contains(track.id())) {
                return new Color(((Integer)RadarConfig.client().hostileColor.get()).intValue());
            }
            if (this.whitelistVS.contains(track.id())) {
                return new Color(((Integer)RadarConfig.client().friendlyColor.get()).intValue());
            }
        }
        return track.getColor();
    }

    private boolean test(TrackCategory trackCategory) {
        if (trackCategory == TrackCategory.PLAYER) {
            return this.player;
        }
        if (trackCategory == TrackCategory.VS2) {
            return this.vs2;
        }
        if (trackCategory == TrackCategory.CONTRAPTION) {
            return this.contraption;
        }
        if (trackCategory == TrackCategory.MOB || trackCategory == TrackCategory.HOSTILE) {
            return this.mob;
        }
        if (trackCategory == TrackCategory.PROJECTILE) {
            return this.projectile;
        }
        if (trackCategory == TrackCategory.ANIMAL) {
            return this.animal;
        }
        if (trackCategory == TrackCategory.ITEM) {
            return this.item;
        }
        return false;
    }
}

