/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.pitch;

import com.happysg.radar.block.controller.firing.FiringControlBlockEntity;
import com.happysg.radar.block.controller.pitch.AutoPitchControllerBlock;
import com.happysg.radar.block.datalink.screens.TargetingConfig;
import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.compat.Mods;
import com.happysg.radar.compat.cbc.CannonTargeting;
import com.happysg.radar.compat.cbc.VS2CannonTargeting;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import com.mojang.logging.LogUtils;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class AutoPitchControllerBlockEntity
extends KineticBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double TOLERANCE = 0.1;
    private double targetAngle;
    public boolean isRunning;
    private boolean artillery = false;
    private RadarTrack track;
    public FiringControlBlockEntity firingControl;
    public CannonMountBlockEntity mountBlock;

    public AutoPitchControllerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void initialize() {
        super.initialize();
        if (Mods.CREATEBIGCANNONS.isLoaded()) {
            BlockEntity blockEntity;
            LOGGER.debug("  \u2192 CBC is loaded");
            BlockPos cannonMountPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING));
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(cannonMountPos)) instanceof CannonMountBlockEntity) {
                CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
                LOGGER.debug("  \u2192 Level not null and cannon pos good");
                this.firingControl = new FiringControlBlockEntity(this, mount);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && Mods.CREATEBIGCANNONS.isLoaded()) {
            LOGGER.debug("pitch.tick() \u2192 isRunning={}", (Object)this.isRunning);
            if (this.isRunning) {
                this.tryRotateCannon();
            }
            if (this.firingControl != null) {
                LOGGER.debug("  \u2192 firingcontrol is not null");
                this.firingControl.tick();
            }
        }
    }

    public BlockPos getMount() {
        BlockPos cannonMountPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING));
        return cannonMountPos;
    }

    private void tryRotateCannon() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        LOGGER.debug("  \u2192 level is good");
        BlockPos cannonMountPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING));
        BlockEntity blockEntity = this.f_58857_.m_7702_(cannonMountPos);
        if (!(blockEntity instanceof CannonMountBlockEntity)) {
            return;
        }
        CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
        LOGGER.debug("  \u2192 CannonMountEntity Gucci");
        PitchOrientedContraptionEntity contraption = mount.getContraption();
        if (contraption == null) {
            return;
        }
        LOGGER.debug("  \u2192 Contraption is not null");
        Contraption contraption2 = contraption.getContraption();
        if (!(contraption2 instanceof AbstractMountedCannonContraption)) {
            return;
        }
        AbstractMountedCannonContraption cannonContraption = (AbstractMountedCannonContraption)contraption2;
        double currentPitch = contraption.pitch;
        LOGGER.debug("  \u2192 Current pitch {}", (Object)currentPitch);
        int invert = -cannonContraption.initialOrientation().m_122429_() + cannonContraption.initialOrientation().m_122431_();
        LOGGER.debug("  \u2192 Current After Invert pitch {}", (Object)(currentPitch *= (double)(-invert)));
        double pitchDifference = this.targetAngle - currentPitch;
        double speedFactor = (double)Math.abs(this.getSpeed()) / 32.0;
        LOGGER.debug("  \u2192 pitchStep (|speed|/32) = {}\u00b0 per tick,   invert = {}", (Object)speedFactor, (Object)invert);
        double newPitch = Math.abs(pitchDifference) > 0.1 ? (Math.abs(pitchDifference) > speedFactor ? currentPitch + Math.signum(pitchDifference) * speedFactor : this.targetAngle) : this.targetAngle;
        double deltaApplied = newPitch - currentPitch;
        LOGGER.debug("\u2192 applying pitch delta = {}\u00b0 per tick", (Object)deltaApplied);
        mount.setPitch((float)newPitch);
        mount.notifyUpdate();
    }

    public boolean atTargetPitch() {
        BlockEntity blockEntity;
        BlockPos turretPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING));
        if (this.f_58857_ == null || !((blockEntity = this.f_58857_.m_7702_(turretPos)) instanceof CannonMountBlockEntity)) {
            return false;
        }
        CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
        PitchOrientedContraptionEntity contraption = mount.getContraption();
        if (contraption == null) {
            return false;
        }
        int invert = -contraption.getInitialOrientation().m_122431_() + contraption.getInitialOrientation().m_122429_();
        LOGGER.debug("orientation steps: stepX={}, stepZ={}, invert={}", new Object[]{contraption.getInitialOrientation().m_122429_(), contraption.getInitialOrientation().m_122431_(), invert});
        return Math.abs((double)(contraption.pitch * (float)invert) - this.targetAngle) < 0.1;
    }

    public void setTargetAngle(float targetAngle) {
        LOGGER.debug("  \u2192 SetTargetAngle Ran");
        this.targetAngle = targetAngle;
    }

    public double getTargetAngle() {
        LOGGER.debug("  \u2192 getTargetAngle Ran");
        return this.targetAngle;
    }

    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.targetAngle = compound.m_128459_("TargetAngle");
        this.isRunning = compound.m_128471_("IsRunning");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128347_("TargetAngle", this.targetAngle);
        compound.m_128379_("IsRunning", this.isRunning);
    }

    public void setTarget(Vec3 targetPos) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            LOGGER.debug(" \u2022 bailing: client side or null target \u2192 isRunning=false");
            return;
        }
        if (targetPos == null) {
            this.isRunning = false;
            return;
        }
        LOGGER.debug("\u2192 setTarget called with {}", (Object)targetPos);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING)));
        if (blockEntity instanceof CannonMountBlockEntity) {
            CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
            if (PhysicsHandler.isBlockInShipyard(this.f_58857_, this.m_58899_())) {
                angles = VS2CannonTargeting.calculatePitchAndYawVS2(mount, targetPos, (ServerLevel)this.f_58857_);
                if (angles == null) {
                    return;
                }
                if (angles.isEmpty()) {
                    return;
                }
                if (((List)angles.get(0)).isEmpty()) {
                    return;
                }
                this.targetAngle = (Double)((List)angles.get(0)).get(0);
                LOGGER.debug("  Computed targetAngle (CBC) = {} rad {}}", (Object)this.targetAngle, (Object)Math.toDegrees(this.targetAngle));
                if (this.firingControl == null) {
                    return;
                }
                LOGGER.debug(" Firing control not null");
                this.firingControl.cannonMount.setYaw(((Double)((List)angles.get(0)).get(1)).floatValue());
                this.isRunning = true;
            } else {
                angles = CannonTargeting.calculatePitch(mount, targetPos, (ServerLevel)this.f_58857_);
                if (angles == null) {
                    LOGGER.debug("   \u2022 calculatePitch returned null \u2192 aborting, isRunning=false");
                    this.isRunning = false;
                    return;
                }
                if (angles.isEmpty()) {
                    LOGGER.debug("   \u2022 calculatePitch returned empty list \u2192 aborting, isRunning=false");
                    this.isRunning = false;
                    return;
                }
                LOGGER.debug("   \u2022 raw angles = {}", angles);
                ArrayList<Double> usableAngles = new ArrayList<Double>();
                Iterator<Object> iterator = angles.iterator();
                while (iterator.hasNext()) {
                    double angle = (Double)iterator.next();
                    if (mount.getContraption() == null) break;
                    if (!(angle < (double)mount.getContraption().maximumElevation()) || !(angle > (double)(-mount.getContraption().maximumDepression()))) continue;
                    usableAngles.add(angle);
                }
                LOGGER.debug("   \u2022 usable angles = {}", usableAngles);
                if (this.artillery && usableAngles.size() == 2) {
                    this.targetAngle = (Double)angles.get(1);
                } else if (!usableAngles.isEmpty()) {
                    this.targetAngle = (Double)usableAngles.get(0);
                }
                this.isRunning = true;
                LOGGER.debug("   \u2022 computed targetAngle={}\u00b0 ({} rad) \u2192 isRunning=true", (Object)this.targetAngle, (Object)Math.toDegrees(this.targetAngle));
                LOGGER.debug(">>> pitch.setTarget() on SERVER at {} \u2192 target={}", (Object)this.f_58858_, (Object)targetPos);
            }
        }
    }

    public void setTrack(RadarTrack track) {
        this.track = track;
    }

    public void setFiringTarget(Vec3 targetPos, TargetingConfig targetingConfig) {
        LOGGER.debug("PitchController.setFiringTarget: targetPos={}", (Object)targetPos);
        if (this.firingControl == null) {
            BlockEntity blockEntity;
            BlockPos mountPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING));
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(mountPos)) instanceof CannonMountBlockEntity) {
                CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
                LOGGER.debug("   \u2022 no mount at {} \u2192 isRunning=false", (Object)mountPos);
                this.firingControl = new FiringControlBlockEntity(this, mount);
            }
        }
        if (this.firingControl == null) {
            LOGGER.debug("PitchController: No firingControl available, skipping setFiringTarget");
            return;
        }
        this.firingControl.setTarget(targetPos, targetingConfig, this.track);
    }

    public void setSafeZones(List<AABB> safeZones) {
        if (this.firingControl == null) {
            return;
        }
        this.firingControl.setSafeZones(safeZones);
    }
}

