/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.firing;

import com.happysg.radar.block.controller.pitch.AutoPitchControllerBlockEntity;
import com.happysg.radar.block.controller.yaw.AutoYawControllerBlockEntity;
import com.happysg.radar.block.datalink.screens.TargetingConfig;
import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.compat.cbc.CannonTargeting;
import com.happysg.radar.compat.cbc.CannonUtil;
import com.happysg.radar.config.RadarConfig;
import com.mojang.logging.LogUtils;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class FiringControlBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TARGET_TIMEOUT_TICKS = 20;
    private TargetingConfig targetingConfig = TargetingConfig.DEFAULT;
    private Vec3 target;
    private boolean firing;
    private float offset;
    private boolean prevAssemblyPowered = false;
    private boolean prevFirePowered = false;
    public final CannonMountBlockEntity cannonMount;
    public final AutoPitchControllerBlockEntity pitchController;
    public final Level level;
    private RadarTrack activetrack;
    public List<AABB> safeZones = new ArrayList<AABB>();
    private long lastTargetTick = -1L;

    public FiringControlBlockEntity(AutoPitchControllerBlockEntity controller, CannonMountBlockEntity cannonMount) {
        this.cannonMount = cannonMount;
        this.pitchController = controller;
        this.level = cannonMount.m_58904_();
        LOGGER.debug("FiringControlBlockEntity.<init>() \u2192 controller={} mountPos={}", (Object)controller, (Object)cannonMount.m_58899_());
    }

    private RayResult rayClear(Vec3 start, Vec3 end) {
        Level level;
        double targetDist;
        double hitDist;
        ClipContext ctx;
        BlockHitResult hit;
        RayResult result = RayResult.CLEAR;
        if (!this.safeZones.isEmpty()) {
            for (AABB zone : this.safeZones) {
                if (zone == null) continue;
                Optional entry = zone.m_82371_(start, end);
                Optional exit = zone.m_82371_(end, start);
                if (!entry.isPresent() || !exit.isPresent()) continue;
                result = RayResult.BLOCKED_SAFEZONE;
                break;
            }
        }
        if (result == RayResult.CLEAR && (hit = this.level.m_45547_(ctx = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null))).m_6662_() != HitResult.Type.MISS && (hitDist = hit.m_82450_().m_82554_(start)) < (targetDist = end.m_82554_(start))) {
            result = RayResult.BLOCKED_BLOCK;
        }
        if (RadarConfig.DEBUG_BEAMS && (level = this.level) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.debugRay(server, start, end, result);
        }
        return result;
    }

    private boolean checkLineOfSight(Vec3 target) {
        if (this.activetrack == null) {
            return false;
        }
        float height = this.activetrack.getEnityHeight();
        int blocksHigh = (int)Math.ceil(height);
        Vec3 start = this.cannonMount.m_58899_().m_252807_().m_82520_(0.0, 2.0, 0.0);
        if (target == null) {
            return false;
        }
        for (int h = 0; h < blocksHigh; ++h) {
            Vec3 end = target.m_82520_(0.0, (double)h + 0.5, 0.0);
            if (!this.rayClear(start, end).isClear()) continue;
            this.offset = (float)h + 0.5f;
            return true;
        }
        return false;
    }

    private void debugRay(ServerLevel server, Vec3 start, Vec3 end, RayResult result) {
        float g;
        float r;
        float b = switch (result) {
            case RayResult.CLEAR -> {
                r = 0.0f;
                g = 1.0f;
                yield 0.0f;
            }
            case RayResult.BLOCKED_BLOCK -> {
                r = 1.0f;
                g = 0.0f;
                yield 0.0f;
            }
            case RayResult.BLOCKED_SAFEZONE -> {
                r = 1.0f;
                g = 1.0f;
                yield 0.0f;
            }
            default -> {
                r = 1.0f;
                g = 1.0f;
                yield 1.0f;
            }
        };
        double dist = start.m_82554_(end);
        Vec3 dir = end.m_82546_(start).m_82541_();
        for (double d = 0.0; d < dist; d += 0.25) {
            Vec3 p = start.m_82549_(dir.m_82490_(d));
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 1.0f), p.f_82479_, p.f_82480_, p.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void setSafeZones(List<AABB> safeZones) {
        LOGGER.debug("setSafeZones() \u2192 {} zones", (Object)safeZones.size());
        this.safeZones = safeZones;
    }

    public void tick() {
        boolean shouldFire;
        LOGGER.debug("tick() start \u2192 target={} lastTargetTick={} safeZones={} autoFire={} firing={}", new Object[]{this.target, this.lastTargetTick, this.safeZones.size(), this.targetingConfig.autoFire(), this.firing});
        boolean pulsedThisTick = false;
        if (this.target != null && this.level != null && this.level.m_46467_() - this.lastTargetTick > 20L) {
            LOGGER.debug("  \u2192 target stale ({} ticks old), clearing", (Object)(this.level.m_46467_() - this.lastTargetTick));
            this.target = null;
        }
        boolean inRange = this.isTargetInRange();
        boolean autoFire = this.targetingConfig.autoFire();
        LOGGER.debug("  \u2192 inRange={} autoFire={}", (Object)inRange, (Object)autoFire);
        boolean bl = shouldFire = this.isTargetInRange() && this.targetingConfig.autoFire();
        if (inRange && autoFire) {
            LOGGER.debug("  \u2192 firing condition met");
            this.tryFireCannon();
        } else {
            LOGGER.debug("  \u2192 firing condition not met");
            this.stopFireCannon();
        }
        if (shouldFire) {
            if (!pulsedThisTick) {
                this.tryFireCannon();
                pulsedThisTick = true;
            }
        } else {
            this.stopFireCannon();
        }
    }

    public static Vec3 calculateLead(CannonMountBlockEntity mount, RadarTrack track, Vec3 targetPos) {
        double t2;
        double s2;
        double C;
        Vec3 toTarget = track.getPosition().m_82546_(targetPos);
        PitchOrientedContraptionEntity projModifier = mount.getContraption();
        if (projModifier == null) {
            return targetPos;
        }
        double sx = toTarget.f_82479_;
        double vx = track.getVelocity().f_82479_;
        double sy = toTarget.f_82480_;
        double vy = track.getVelocity().f_82480_;
        double sz = toTarget.f_82481_;
        double vz = track.getVelocity().f_82481_;
        double B = 2.0 * (sx * vx + sy * vy + sz * vz);
        double v2 = vx * vx + vy * vy + vz * vz;
        float projectileSpeed = (projModifier.m_20205_() - 1.0f) * 20.0f;
        double A = v2 - (double)(projectileSpeed * projectileSpeed);
        double discriminant = B * B - 4.0 * A * (C = (s2 = sx * sx + sy * sy + sz * sz));
        if (discriminant < 0.0) {
            return targetPos;
        }
        double sqrtD = Math.sqrt(discriminant);
        double t1 = (-B - sqrtD) / (2.0 * A);
        double t = Math.min(t1, t2 = (-B + sqrtD) / (2.0 * A));
        if (t < 0.0) {
            t = Math.max(t1, t2);
        }
        if (t < 0.0) {
            return targetPos;
        }
        return targetPos.m_82549_(track.getVelocity().m_82490_(t));
    }

    public void setTarget(Vec3 target, TargetingConfig config, RadarTrack track) {
        BlockEntity blockEntity;
        BlockPos yawPos;
        Vec3 offsettarget;
        LOGGER.debug("setTarget() \u2192 new target={} config={} atTick={}", new Object[]{target, config, this.level != null ? this.level.m_46467_() : -1L});
        this.activetrack = track;
        if (target == null) {
            LOGGER.debug("  \u2192 target null, stopping fire");
            this.target = null;
            this.stopFireCannon();
            return;
        }
        this.target = target;
        this.targetingConfig = config;
        this.lastTargetTick = this.level != null ? this.level.m_46467_() : 0L;
        Vec3 leadtarget = offsettarget = target.m_82520_(0.0, (double)this.offset, 0.0);
        if (this.pitchController != null) {
            LOGGER.debug("  \u2192 forwarding target to pitchController");
            this.pitchController.setTarget(leadtarget);
        }
        if (!(this.level.m_7702_(yawPos = this.cannonMount.m_58899_().m_7495_()) instanceof AutoYawControllerBlockEntity)) {
            yawPos = this.cannonMount.m_58899_().m_7494_();
            LOGGER.debug("  \u2192 yawPos = {}", (Object)yawPos);
        }
        if ((blockEntity = this.level.m_7702_(yawPos)) instanceof AutoYawControllerBlockEntity) {
            AutoYawControllerBlockEntity yawCtrl = (AutoYawControllerBlockEntity)blockEntity;
            LOGGER.debug("  \u2192 forwarding target to yawController at {}", (Object)yawPos);
            yawCtrl.setTarget(leadtarget);
        }
    }

    private boolean isTargetInRange() {
        boolean hasTarget = this.target != null;
        boolean correctOrient = this.hasCorrectYawPitch();
        boolean safeZoneClear = !this.passesSafeZone();
        boolean lineOfSight = this.checkLineOfSight(this.target);
        LOGGER.debug("isTargetInRange() check \u2192 hasTarget={}, yawPitchOK={}, safeZoneClear={}", new Object[]{hasTarget, correctOrient, safeZoneClear});
        return hasTarget && correctOrient && safeZoneClear && lineOfSight;
    }

    private boolean passesSafeZone() {
        LOGGER.debug("passesSafeZone() \u2192 checking {} safe zones", (Object)this.safeZones.size());
        if (this.safeZones.isEmpty()) {
            return false;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            LOGGER.debug("  \u2192 not server level, skip safe-zone check");
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.target == null) {
            LOGGER.debug("  \u2192 target is null, skipping safe zone check");
            return false;
        }
        Vec3 cannonPos = this.cannonMount.m_58899_().m_252807_();
        for (AABB zone : this.safeZones) {
            Contraption contraption;
            if (zone == null) continue;
            if (zone.m_82390_(this.target)) {
                LOGGER.debug("  \u2192 target {} inside zone {}", (Object)this.target, (Object)zone);
                return true;
            }
            Vec3 baseCannon = new Vec3(cannonPos.f_82479_, zone.f_82289_, cannonPos.f_82481_);
            Vec3 baseTarget = new Vec3(this.target.f_82479_, zone.f_82289_, this.target.f_82481_);
            Optional oMin = zone.m_82371_(baseCannon, baseTarget);
            Optional oMax = zone.m_82371_(baseTarget, baseCannon);
            if (oMin.isEmpty() || oMax.isEmpty()) {
                LOGGER.debug("  \u2192 no intersection segment for zone {}", (Object)zone);
                continue;
            }
            Vec3 minX = (Vec3)oMin.get();
            Vec3 maxX = (Vec3)oMax.get();
            double yMin = zone.f_82289_ - (double)this.cannonMount.m_58899_().m_123342_();
            double yMax = zone.f_82292_ - (double)this.cannonMount.m_58899_().m_123342_();
            LOGGER.debug("  yMin: {}, yMax: {}", (Object)yMin, (Object)yMax);
            PitchOrientedContraptionEntity contraption2 = this.cannonMount.getContraption();
            if (contraption2 == null || !((contraption = contraption2.getContraption()) instanceof AbstractMountedCannonContraption)) {
                LOGGER.warn("  \u2192 cannon contraption missing or invalid, skipping");
                continue;
            }
            AbstractMountedCannonContraption cc = (AbstractMountedCannonContraption)contraption;
            float speed = CannonUtil.getInitialVelocity(cc, serverLevel);
            double drag = CannonUtil.getProjectileDrag(cc, serverLevel);
            double grav = CannonUtil.getProjectileGravity(cc, serverLevel);
            int length = CannonUtil.getBarrelLength(cc);
            LOGGER.debug("  Speed: {}, Drag: {}, Grav: {}, Length: {}", new Object[]{Float.valueOf(speed), drag, grav, length});
            double theta = Math.toRadians(this.cannonMount.getDisplayPitch());
            double distMin = cannonPos.m_82554_(minX) - (double)length * Math.cos(theta);
            double distMax = cannonPos.m_82554_(maxX) - (double)length * Math.cos(theta);
            double yAtMin = CannonTargeting.calculateProjectileYatX(speed, distMin, theta, drag, grav);
            double yAtMax = CannonTargeting.calculateProjectileYatX(speed, distMax, theta, drag, grav);
            LOGGER.debug("  \u2192 zone {}: yAtMin={}, yAtMax={} vs yMin={}, yMax={}", new Object[]{zone, yAtMin, yAtMax, yMin, yMax});
            if (!(yAtMin >= yMin && yAtMax <= yMax) && (!(yAtMin <= yMin) || !(yAtMax >= yMin))) continue;
            LOGGER.debug("  \u2192 trajectory passes through zone {}", (Object)zone);
            return true;
        }
        LOGGER.debug("passesSafeZone() \u2192 false");
        return false;
    }

    private boolean hasCorrectYawPitch() {
        BlockEntity blockEntity;
        LOGGER.debug("hasCorrectYawPitch() start");
        BlockPos below = this.cannonMount.m_58899_().m_7495_();
        if (!(this.level.m_7702_(below) instanceof AutoYawControllerBlockEntity)) {
            below = this.cannonMount.m_58899_().m_7494_();
            LOGGER.debug("  \u2192 no yaw controller at {}", (Object)below);
        }
        if (!((blockEntity = this.level.m_7702_(below)) instanceof AutoYawControllerBlockEntity)) {
            LOGGER.debug("  \u2192 no yaw controller at {}", (Object)below);
            return false;
        }
        AutoYawControllerBlockEntity yawCtrl = (AutoYawControllerBlockEntity)blockEntity;
        boolean ok = yawCtrl.atTargetYaw() && this.pitchController.atTargetPitch();
        LOGGER.debug("  \u2192 yaw ok={}, pitch ok={}", (Object)yawCtrl.atTargetYaw(), (Object)this.pitchController.atTargetPitch());
        return ok;
    }

    private void stopFireCannon() {
        LOGGER.debug("stopFireCannon() \u2192 sending redstone OFF");
        boolean assembly = true;
        this.cannonMount.onRedstoneUpdate(assembly, this.prevAssemblyPowered, false, this.prevFirePowered, 0);
        this.prevAssemblyPowered = assembly;
        this.prevFirePowered = false;
        this.firing = false;
    }

    private void tryFireCannon() {
        LOGGER.debug("tryFireCannon() \u2192 pulsing redstone ON");
        boolean assembly = true;
        this.cannonMount.onRedstoneUpdate(assembly, this.prevAssemblyPowered, false, this.prevFirePowered, 0);
        this.prevAssemblyPowered = assembly;
        this.prevFirePowered = false;
        this.cannonMount.onRedstoneUpdate(assembly, this.prevAssemblyPowered, true, this.prevFirePowered, 15);
        this.prevAssemblyPowered = assembly;
        this.prevFirePowered = true;
        this.firing = true;
    }

    private static enum RayResult {
        CLEAR,
        BLOCKED_BLOCK,
        BLOCKED_SAFEZONE;


        public boolean isClear() {
            return this == CLEAR;
        }
    }
}

