/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.setup;

import com.mcjty.fancytrinkets.api.ITrinketItem;
import com.mcjty.fancytrinkets.modules.trinkets.items.TrinketItemCapabilityProvider;
import com.mcjty.fancytrinkets.modules.trinkets.items.TrinketItemData;
import com.mcjty.fancytrinkets.playerdata.PlayerEffects;
import com.mcjty.fancytrinkets.playerdata.PropertiesDispatcher;
import com.mcjty.fancytrinkets.setup.Config;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeEventHandlers {
    private final Map<Item, TrinketItemData> dataForAdditionalTrinkets = new HashMap<Item, TrinketItemData>();

    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(playerEffects -> {
                String msgId = event.getSource().m_19385_();
                float reduction = playerEffects.getDamageReduction(msgId);
                float damage = event.getAmount() * reduction;
                event.setAmount(damage);
                if (damage < 1.0E-5f) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public void onItemConstructing(AttachCapabilitiesEvent<ItemStack> event) {
        if (Config.isAdditionalTrinketItem(((ItemStack)event.getObject()).m_41720_())) {
            ITrinketItem trinketItem = this.dataForAdditionalTrinkets.computeIfAbsent(((ItemStack)event.getObject()).m_41720_(), k -> new TrinketItemData());
            event.addCapability(new ResourceLocation("fancytrinkets", "trinketitem"), (ICapabilityProvider)new TrinketItemCapabilityProvider((ItemStack)event.getObject(), () -> trinketItem));
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerEffects.PLAYER_EFFECTS).isPresent()) {
            event.addCapability(new ResourceLocation("fancytrinkets", "playereffects"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(oldStore -> event.getEntity().getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(newStore -> newStore.copyFrom((PlayerEffects)oldStore)));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(playerEffects -> playerEffects.tick(serverPlayer));
        }
    }
}

