/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.playerdata;

import com.mcjty.fancytrinkets.modules.effects.IEffect;
import com.mcjty.fancytrinkets.playerdata.PacketSyncPlayerEffects;
import com.mcjty.fancytrinkets.setup.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.Counter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class PlayerEffects {
    public static final Capability<PlayerEffects> PLAYER_EFFECTS = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerEffects>(){});
    private final Map<String, EffectHolder> effectMap = new HashMap<String, EffectHolder>();
    private final Set<String> toggles = new HashSet<String>();
    private final Map<String, Float> damageReduction = new HashMap<String, Float>();

    public Set<String> getToggles() {
        return this.toggles;
    }

    public void tick(ServerPlayer player) {
        long time = player.m_9236_().m_46467_();
        Counter collectedEffects = new Counter();
        ArrayList<String> toDelete = new ArrayList<String>();
        for (Map.Entry<String, EffectHolder> entry : this.effectMap.entrySet()) {
            EffectHolder holder = entry.getValue();
            if (holder.endTime >= time) {
                collectedEffects.increment((Object)holder.effect);
                continue;
            }
            toDelete.add(entry.getKey());
        }
        for (Map.Entry<String, EffectHolder> entry : collectedEffects.entrySet()) {
            ((IEffect)((Object)entry.getKey())).perform(player, (Integer)((Object)entry.getValue()));
        }
        for (String index : toDelete) {
            this.effectMap.remove(index);
        }
    }

    public boolean toggle(ServerPlayer player, String toggle) {
        if (this.toggles.contains(toggle)) {
            this.toggles.remove(toggle);
        } else {
            this.toggles.add(toggle);
        }
        Messages.sendToPlayer(PacketSyncPlayerEffects.create(this), (Player)player);
        return this.isToggleOn(toggle);
    }

    public boolean isToggleOn(String toggle) {
        return this.toggles.contains(toggle);
    }

    public void registerEffect(String slotId, IEffect effect, long endTime) {
        this.effectMap.put(slotId, new EffectHolder(effect, endTime));
    }

    public void unregisterEffect(String slotId) {
        this.effectMap.remove(slotId);
    }

    public void registerDamageReduction(String dmgId, float factor) {
        this.damageReduction.put(dmgId, Float.valueOf(factor));
    }

    public void unregisterDamageReduction(String dmgId) {
        this.damageReduction.remove(dmgId);
    }

    public float getDamageReduction(String dmgId) {
        return this.damageReduction.getOrDefault(dmgId, Float.valueOf(1.0f)).floatValue();
    }

    public void copyFrom(PlayerEffects source) {
        this.effectMap.clear();
        this.effectMap.putAll(source.effectMap);
    }

    public void saveNBTData(CompoundTag tag) {
        ListTag toggleList = new ListTag();
        for (String toggle : this.toggles) {
            toggleList.add((Object)StringTag.m_129297_((String)toggle));
        }
        tag.m_128365_("toggles", (Tag)toggleList);
        ListTag damageReductionList = new ListTag();
        for (Map.Entry<String, Float> entry : this.damageReduction.entrySet()) {
            CompoundTag cmp = new CompoundTag();
            cmp.m_128359_("dmgId", entry.getKey());
            cmp.m_128350_("factor", entry.getValue().floatValue());
        }
        tag.m_128365_("damageReduction", (Tag)damageReductionList);
    }

    public void loadNBTData(CompoundTag tag) {
        ListTag toggleList = tag.m_128437_("toggles", 8);
        for (Tag toggleTag : toggleList) {
            this.toggles.add(toggleTag.m_7916_());
        }
        ListTag damageReductionList = tag.m_128437_("damageReduction", 10);
        for (Tag cmp : damageReductionList) {
            if (!(cmp instanceof CompoundTag)) continue;
            CompoundTag comp = (CompoundTag)cmp;
            this.damageReduction.put(comp.m_128461_("dmgId"), Float.valueOf(comp.m_128457_("factor")));
        }
    }

    public record EffectHolder(IEffect effect, long endTime) {
    }
}

