/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.xpcrafter.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcjty.fancytrinkets.modules.xpcrafter.XpCrafterModule;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.crafting.IRecipeBuilder;
import mcjty.lib.varia.Tools;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class XpRecipeBuilder
implements IRecipeBuilder<XpRecipeBuilder> {
    private final ItemStack result;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();

    public XpRecipeBuilder(ItemStack result) {
        this.result = result.m_41777_();
    }

    public static XpRecipeBuilder shapedRecipe(ItemStack result) {
        return new XpRecipeBuilder(result);
    }

    public XpRecipeBuilder define(Character symbol, TagKey<Item> tagKey) {
        return this.define(symbol, Ingredient.m_204132_(tagKey));
    }

    public XpRecipeBuilder define(Character symbol, ItemLike itemLike) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
    }

    public XpRecipeBuilder define(Character symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public XpRecipeBuilder patternLine(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public XpRecipeBuilder setGroup(String groupIn) {
        return this;
    }

    public XpRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionIn) {
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, Tools.getId((Item)this.result.m_41720_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, String save) {
        this.build(consumer, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        consumer.accept(new Result(id, this.result, this.pattern, this.key));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack result;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;

        public Result(ResourceLocation id, ItemStack result, List<String> pattern, Map<Character, Ingredient> ingredients) {
            this.id = id;
            this.result = result;
            this.pattern = pattern;
            this.key = ingredients;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Tools.getId((Item)this.result.m_41720_()).toString());
            if (this.result.m_41613_() > 1) {
                jsonObject.addProperty("count", (Number)this.result.m_41613_());
            }
            if (this.result.m_41782_()) {
                CompoundTag.f_128325_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.result.m_41783_()).result().ifPresent(result -> itemObject.add("nbt", result));
            }
            json.add("result", (JsonElement)jsonObject);
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return XpCrafterModule.XP_RECIPE_SERIALIZER.get();
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

