/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.xpcrafter.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;

public class RecipeJsonTools {
    static Map<String, Ingredient> parseKeys(JsonObject keys) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : keys.entrySet()) {
            String key = (String)entry.getKey();
            if (key.length() != 1 || " ".equals(key)) {
                throw new JsonSyntaxException("Invalid key entry: '" + key + "'!");
            }
            map.put(key, Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    static String[] patternFromJson(JsonArray array) {
        String[] result = new String[array.size()];
        if (result.length > 5) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 5 is maximum");
        }
        if (result.length == 0) {
            throw new JsonSyntaxException("Invalid empty pattern");
        }
        for (int i = 0; i < result.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)array.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 5) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 5 is maximum");
            }
            if (i > 0 && result[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            result[i] = s;
        }
        return result;
    }

    static NonNullList<Ingredient> patternToIngredients(String[] pattern, Map<String, Ingredient> keys) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)25, (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Unknown symbol '" + s + "'!");
                }
                set.remove(s);
                nonnulllist.set(j + 5 * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }
}

