/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.xpcrafter.blocks;

import com.mcjty.fancytrinkets.api.ITrinketItem;
import com.mcjty.fancytrinkets.modules.trinkets.items.TrinketItemData;
import com.mcjty.fancytrinkets.modules.xpcrafter.XpCrafterModule;
import com.mcjty.fancytrinkets.modules.xpcrafter.recipe.XpRecipe;
import com.mcjty.fancytrinkets.setup.Config;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public class ExperienceCrafterBE
extends GenericTileEntity {
    public static final int SLOT_OUTPUT = 0;
    public static final int SLOT_PREVIEW = 1;
    public static final int SLOT_GRID = 2;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(27).slot(SlotDefinition.generic().out(), 0, 151, 27).slot(SlotDefinition.ghostOut(), 1, 115, 27).box(SlotDefinition.generic().in(), 2, 10, 11, 5, 5).playerSlots(10, 110));
    @GuiValue
    private int experience = 0;
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).onUpdate(this::onUpdate).build();
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Experience Crafter").containerSupplier(DefaultContainerProvider.container(XpCrafterModule.CONTAINER_EXPERIENCE_CRAFTER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @ServerCommand
    public static final Command<?> CMD_FILLXP = Command.create((String)"fillxp", (te, player, params) -> te.fillExperience((ServerPlayer)player));
    @ServerCommand
    public static final Command<?> CMD_CRAFT = Command.create((String)"craft", (te, player, params) -> te.craft());
    private final CraftingContainer inv = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

        public boolean m_6875_(@Nonnull Player playerIn) {
            return false;
        }

        public ItemStack m_7648_(Player player, int slot) {
            return ItemStack.f_41583_;
        }
    }, 5, 5);

    public ExperienceCrafterBE(BlockPos pos, BlockState state) {
        super(XpCrafterModule.TYPE_EXPERIENCE_CRAFTER.get(), pos, state);
    }

    private void craft() {
        Optional<XpRecipe> result = this.findRecipe();
        result.ifPresent(recipe -> {
            ItemStack stack = recipe.m_5874_(this.inv, Tools.getRegistryAccess((Level)this.f_58857_));
            ItemStack outputSlot = this.items.getStackInSlot(0);
            if (outputSlot.m_41619_()) {
                ItemStack finalStack = stack = stack.m_41777_();
                stack.getCapability(Registration.TRINKET_ITEM_CAPABILITY).ifPresent(trinket -> this.addBonusEffects((ITrinketItem)trinket, finalStack));
                this.items.setStackInSlot(0, stack);
                for (int i = 0; i < 25; ++i) {
                    ItemStack in = this.items.getStackInSlot(2 + i);
                    if (in.m_41619_()) continue;
                    in.m_41764_(in.m_41613_() - ((Ingredient)recipe.m_7527_().get(i)).m_43908_()[0].m_41613_());
                    this.items.setStackInSlot(2 + i, in);
                }
            }
        });
    }

    private void addBonusEffects(ITrinketItem trinket, ItemStack stack) {
        float targetQuality = 100.0f * (float)(this.experience + (Integer)Config.EXPERIENCE_OFFSET.get()) / (float)((Integer)Config.MAXEXPERIENCE.get() + (Integer)Config.EXPERIENCE_OFFSET.get());
        if (TrinketItemData.addBonusEffects(this.f_58857_, trinket, stack, targetQuality)) {
            this.experience = 0;
            this.m_6596_();
        }
    }

    private void onUpdate(int slot, ItemStack stack) {
        if (slot >= 2) {
            this.updatePreview();
        }
    }

    private void updatePreview() {
        Optional<XpRecipe> result = this.findRecipe();
        ItemStack output = result.map(XpRecipe::getResultItem).orElse(ItemStack.f_41583_);
        this.items.setStackInSlot(1, output);
        this.m_6596_();
    }

    @NotNull
    private Optional<XpRecipe> findRecipe() {
        for (int i = 2; i < 27; ++i) {
            this.inv.m_6836_(i - 2, this.items.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_(XpCrafterModule.XP_RECIPE_TYPE.get(), (Container)this.inv, this.f_58857_);
    }

    private void fillExperience(ServerPlayer player) {
        int level = player.f_36078_;
        int maxXp = (int)(player.f_36080_ * (float)player.m_36323_() + (float)ExperienceCrafterBE.getTotalXpForLevel(level));
        int toExtract = Math.min(maxXp, (Integer)Config.MAXEXPERIENCE.get());
        player.m_6756_(-toExtract);
        this.experience += toExtract;
        this.m_6596_();
    }

    public static int getTotalXpForLevel(int level) {
        if (level < 17) {
            return level * level + 6 * level;
        }
        if (level < 32) {
            return Mth.m_14107_((double)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0));
        }
        return Mth.m_14107_((double)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
    }

    public int getExperience() {
        return this.experience;
    }

    public ItemStack getPreviewOutput() {
        return this.items.getStackInSlot(1);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            CompoundTag info = tagCompound.m_128469_("Info");
            this.experience = info.m_128451_("experience");
        }
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.m_128405_("experience", this.experience);
    }
}

