/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.trinkets.items;

import com.mcjty.fancytrinkets.api.ITrinketItem;
import com.mcjty.fancytrinkets.datapack.BonusTable;
import com.mcjty.fancytrinkets.datapack.CustomRegistries;
import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.TrinketDescription;
import com.mcjty.fancytrinkets.keys.KeyBindings;
import com.mcjty.fancytrinkets.modules.effects.EffectInstance;
import com.mcjty.fancytrinkets.modules.effects.IEffect;
import com.mcjty.fancytrinkets.modules.trinkets.TrinketInstance;
import com.mcjty.fancytrinkets.modules.trinkets.TrinketsModule;
import com.mcjty.fancytrinkets.setup.Config;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SafeClientTools;
import mcjty.lib.varia.Tools;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TrinketItemData
implements ITrinketItem {
    public static final String MESSAGE_FANCYTRINKETS_SHIFTMESSAGE = "message.fancytrinkets.shiftmessage";
    public static final String MESSAGE_FANCYTRINKETS_BONUS = "message.fancytrinkets.bonus";
    private static final Random random = new Random();
    private final Map<ResourceLocation, TrinketInstance> trinkets = new HashMap<ResourceLocation, TrinketInstance>();
    public static Set<String> toggles = new HashSet<String>();

    @Override
    public Set<String> getActiveToggles() {
        return toggles;
    }

    public static boolean addBonusEffects(Level level, ITrinketItem trinket, ItemStack stack, float targetQuality) {
        BonusTable bonusTable;
        ResourceLocation bonusTableId;
        ResourceLocation id = trinket.getTrinketId(stack);
        TrinketDescription description = (TrinketDescription)Tools.getRegistryAccess((Level)level).m_175515_(CustomRegistries.TRINKET_REGISTRY_KEY).m_7745_(id);
        if (description != null && (bonusTableId = description.bonusTableId()) != null && (bonusTable = (BonusTable)Tools.getRegistryAccess((Level)level).m_175515_(CustomRegistries.BONUS_TABLE_REGISTRY_KEY).m_7745_(bonusTableId)) != null) {
            ArrayList<ResourceLocation> effects = new ArrayList<ResourceLocation>();
            if (!bonusTable.effects().isEmpty()) {
                List<BonusTable.EffectRef> list = Collections.emptyList();
                float maxDiff = 10.0f;
                while (list.size() < 9) {
                    list = TrinketItemData.findSuitableEffects(bonusTable.effects(), targetQuality, maxDiff);
                    maxDiff += 5.0f;
                }
                if (random.nextDouble(100.0) <= (Double)Config.CHANCE_BONUS_EFFECT1.get()) {
                    TrinketItemData.addEffect(targetQuality, effects, list);
                    if (random.nextDouble(100.0) <= (Double)Config.CHANCE_BONUS_EFFECT2.get()) {
                        TrinketItemData.addEffect(targetQuality, effects, list);
                        if (random.nextDouble(100.0) <= (Double)Config.CHANCE_BONUS_EFFECT3.get()) {
                            TrinketItemData.addEffect(targetQuality, effects, list);
                            if (random.nextDouble(100.0) <= (Double)Config.CHANCE_BONUS_EFFECT4.get()) {
                                TrinketItemData.addEffect(targetQuality, effects, list);
                            }
                        }
                    }
                }
            }
            trinket.addEffects(stack, effects);
            return true;
        }
        return false;
    }

    private static List<BonusTable.EffectRef> findSuitableEffects(List<BonusTable.EffectRef> list, float desiredQuality, float maxDiff) {
        return list.stream().filter(ref -> Math.abs(ref.quality() - desiredQuality) <= maxDiff).collect(Collectors.toList());
    }

    private static void addEffect(float targetQuality, List<ResourceLocation> effects, List<BonusTable.EffectRef> list) {
        int bestIndex = -1;
        float bestDiff = Float.MAX_VALUE;
        for (int i = 0; i < 5; ++i) {
            BonusTable.EffectRef ref = list.get(random.nextInt(list.size()));
            float diff = Math.abs(ref.quality() - targetQuality);
            if (!(diff < bestDiff)) continue;
            bestDiff = diff;
            bestIndex = i;
        }
        ResourceLocation id = list.remove(bestIndex).effect();
        effects.add(id);
    }

    @Override
    public void addEffects(ItemStack stack, List<ResourceLocation> effects) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = new ListTag();
        for (ResourceLocation location : effects) {
            list.add((Object)StringTag.m_129297_((String)location.toString()));
        }
        tag.m_128365_("effects", (Tag)list);
    }

    public static Stream<ResourceLocation> getEffects(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            ListTag effects = tag.m_128437_("effects", 8);
            return effects.stream().map(s -> new ResourceLocation(s.m_7916_()));
        }
        return Stream.empty();
    }

    public static ItemStack createTrinketStack(Level level, TrinketDescription description, ResourceLocation id, float quality) {
        ItemStack stack = TrinketItemData.createTrinketStack(description, id);
        stack.getCapability(Registration.TRINKET_ITEM_CAPABILITY).ifPresent(trinket -> TrinketItemData.addBonusEffects(level, trinket, stack, quality));
        return stack;
    }

    @NotNull
    public static ItemStack createTrinketStack(TrinketDescription description, ResourceLocation id) {
        ResourceLocation itemId = description.item();
        Item item = Tools.getItem((ResourceLocation)itemId);
        if (item == null) {
            throw new RuntimeException("Cannot find item for trinket '" + id.toString() + "'!");
        }
        ItemStack result = new ItemStack((ItemLike)item);
        result.m_41784_().m_128359_("id", id.toString());
        return result;
    }

    @Override
    public ResourceLocation getTrinketId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("id")) {
            return new ResourceLocation(tag.m_128461_("id"));
        }
        return null;
    }

    @Override
    public TrinketInstance getTrinketInstance(Level level, ResourceLocation id) {
        Map<ResourceLocation, TrinketInstance> map = this.getTrinkets(level);
        return map.get(id);
    }

    @Override
    public void registerTrinketInstance(Level level, ResourceLocation id, TrinketDescription description) {
        this.trinkets.put(id, description.build(id, level));
    }

    public Map<ResourceLocation, TrinketInstance> getTrinkets(Level level) {
        if (this.trinkets.isEmpty()) {
            TrinketsModule.registerTrinkets(level);
        }
        return this.trinkets;
    }

    @Override
    public void forAllEffects(Level level, ItemStack stack, BiConsumer<IEffect, Integer> consumer) {
        ResourceLocation trinketId = this.getTrinketId(stack);
        if (trinketId != null) {
            AtomicInteger idx = new AtomicInteger(0);
            TrinketInstance instance = this.getTrinkets(level).get(trinketId);
            if (instance != null) {
                for (EffectInstance effect2 : instance.effects()) {
                    consumer.accept(effect2.effect(), idx.incrementAndGet());
                }
            }
            Registry registry = Tools.getRegistryAccess((Level)level).m_175515_(CustomRegistries.EFFECT_REGISTRY_KEY);
            TrinketItemData.getEffects(stack).forEach(effect -> {
                EffectDescription description = (EffectDescription)registry.m_7745_(effect);
                if (description != null) {
                    consumer.accept(description.effect(), idx.incrementAndGet());
                }
            });
        }
    }

    public static void appendHoverText(ITrinketItem trinketItem, ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        TrinketInstance instance;
        ResourceLocation trinketId = trinketItem.getTrinketId(stack);
        if (trinketId != null && (instance = trinketItem.getTrinketInstance(world, trinketId)) != null) {
            MutableComponent name = ComponentFactory.translatable((String)instance.nameKey()).m_130940_(ChatFormatting.AQUA);
            if (list.isEmpty()) {
                list.add((Component)name);
            } else {
                list.set(0, (Component)name);
            }
            list.add((Component)ComponentFactory.translatable((String)instance.descriptionKey()));
            for (EffectInstance effectInstance : instance.effects()) {
                Integer hotkey;
                IEffect effect2 = effectInstance.effect();
                if (effectInstance.hidden()) continue;
                MutableComponent translatable = ComponentFactory.translatable((String)("effectId." + effectInstance.id().m_135827_() + "." + effectInstance.id().m_135815_()));
                String toggle = effect2.getToggle();
                ChatFormatting color = ChatFormatting.BLUE;
                ChatFormatting style = ChatFormatting.BLUE;
                if (toggle != null && !toggles.contains(toggle)) {
                    color = ChatFormatting.GRAY;
                    style = ChatFormatting.STRIKETHROUGH;
                }
                if ((hotkey = effect2.getHotkey()) != null) {
                    Component key = KeyBindings.toggles[hotkey - 1].getKey().m_84875_();
                    MutableComponent key2 = ComponentFactory.literal((String)" [Key ").m_130940_(ChatFormatting.YELLOW).m_7220_(key).m_130946_("]");
                    list.add((Component)ComponentFactory.literal((String)"    ").m_7220_((Component)translatable.m_130940_(color).m_130940_(style).m_7220_((Component)key2)));
                    continue;
                }
                list.add((Component)ComponentFactory.literal((String)"    ").m_7220_((Component)translatable.m_130940_(color).m_130940_(style)));
            }
            AtomicBoolean first = new AtomicBoolean(true);
            TrinketItemData.getEffects(stack).forEach(effect -> {
                if (first.get()) {
                    list.add((Component)ComponentFactory.translatable((String)MESSAGE_FANCYTRINKETS_BONUS).m_130940_(ChatFormatting.AQUA));
                    first.set(false);
                }
                MutableComponent translatable = ComponentFactory.translatable((String)("effectId." + effect.m_135827_() + "." + effect.m_135815_()));
                ChatFormatting color = ChatFormatting.GREEN;
                EffectDescription description = (EffectDescription)Tools.getRegistryAccess((Level)SafeClientTools.getClientWorld()).m_175515_(CustomRegistries.EFFECT_REGISTRY_KEY).m_7745_(effect);
                if (description != null && description.harmful()) {
                    color = ChatFormatting.RED;
                }
                list.add((Component)ComponentFactory.literal((String)"    ").m_7220_((Component)translatable).m_130940_(color));
            });
        }
    }
}

