/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.trinkets.items;

import com.mcjty.fancytrinkets.api.ITrinketItem;
import com.mcjty.fancytrinkets.modules.trinkets.TrinketsModule;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class TrinketItemCapabilityProvider
implements ICapabilityProvider {
    private final ItemStack itemStack;
    private final Supplier<ITrinketItem> trinketItem;
    private final LazyOptional<ICurio> curio = LazyOptional.of(this::createCurio);
    private final LazyOptional<ITrinketItem> trinket = LazyOptional.of(this::getTrinket);

    public TrinketItemCapabilityProvider(ItemStack itemStack, Supplier<ITrinketItem> trinketItem) {
        this.itemStack = itemStack;
        this.trinketItem = trinketItem;
    }

    @Nonnull
    private ITrinketItem getTrinket() {
        return this.trinketItem.get();
    }

    @Nonnull
    private ICurio createCurio() {
        return new ICurio(){

            public ItemStack getStack() {
                return TrinketItemCapabilityProvider.this.itemStack;
            }

            public void curioTick(SlotContext slotContext) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    String slotId = slotContext.identifier() + slotContext.index() + "_";
                    TrinketItemCapabilityProvider.this.trinketItem.get().forAllEffects(player.m_9236_(), TrinketItemCapabilityProvider.this.itemStack, (effect, idx) -> effect.tick(TrinketItemCapabilityProvider.this.itemStack, player, slotId + idx));
                }
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    String slotId = slotContext.identifier() + slotContext.index() + "_";
                    TrinketItemCapabilityProvider.this.trinketItem.get().forAllEffects(player.m_9236_(), TrinketItemCapabilityProvider.this.itemStack, (effect, idx) -> effect.onEquip(TrinketItemCapabilityProvider.this.itemStack, player, slotId + idx));
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    String slotId = slotContext.identifier() + slotContext.index() + "_";
                    TrinketItemCapabilityProvider.this.trinketItem.get().forAllEffects(player.m_9236_(), TrinketItemCapabilityProvider.this.itemStack, (effect, idx) -> effect.onUnequip(TrinketItemCapabilityProvider.this.itemStack, player, slotId + idx));
                }
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == TrinketsModule.CURIOS_CAPABILITY) {
            return this.curio.cast();
        }
        if (cap == Registration.TRINKET_ITEM_CAPABILITY) {
            return this.trinket.cast();
        }
        return LazyOptional.empty();
    }
}

