/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.trinkets;

import com.mcjty.fancytrinkets.datapack.TrinketDescription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class DefaultTrinkets {
    public static final Map<ResourceLocation, TrinketInfo> DEFAULT_TRINKETS = new HashMap<ResourceLocation, TrinketInfo>();

    static void init() {
        DEFAULT_TRINKETS.clear();
        DefaultTrinkets.register("base_star", DefaultTrinkets.trinket("base_star", "star", new TrinketDescription.EffectRef[0]), "Base Star", "Crafting ingredient to make star trinkets");
        DefaultTrinkets.register("flight_star", DefaultTrinkets.trinket("flight_star", "star", DefaultTrinkets.effect("flight")), "Sky Star", "This star gives you the freedom of flight");
        DefaultTrinkets.register("power_star", DefaultTrinkets.trinket("power_star", "star", DefaultTrinkets.effect("attack_range"), DefaultTrinkets.effect("attack_speed"), DefaultTrinkets.effect("attack_damage"), DefaultTrinkets.effect("reach_distance")), "Power Star", "You feel the power surging through you!");
        DefaultTrinkets.register("swift_star", DefaultTrinkets.trinket("swift_star", "star", DefaultTrinkets.effect("movement_speed"), DefaultTrinkets.effect("knockback_resistance"), DefaultTrinkets.effect("swim_speed"), DefaultTrinkets.effect("step_assist")), "Star of Swiftness", "Feel the freedom of swift and flexible movement");
        DefaultTrinkets.register("slowfalling_feather", DefaultTrinkets.trinket("slowfalling_feather", "feather", DefaultTrinkets.effect("slow_falling")), "Golden Feather", "Gravity seems to have less effect on you");
        DefaultTrinkets.register("base_gold_ring", DefaultTrinkets.trinket("base_gold_ring", "gold_ring", new TrinketDescription.EffectRef[0]), "Base Golden Ring", "Crafting ingredient to make golden ring trinkets");
        DefaultTrinkets.register("lightness_ring", DefaultTrinkets.trinket("lightness_ring", "gold_ring", DefaultTrinkets.effect("dmg_fall_75")), "Ring of Lightness", "Reduce 75% of fall damage");
        DefaultTrinkets.register("fireresist_ring", DefaultTrinkets.trinket("fireresist_ring", "gold_ring", DefaultTrinkets.effect("dmg_infire_100"), DefaultTrinkets.hidden("dmg_hotfloor_100"), DefaultTrinkets.hidden("dmg_onfire_100"), DefaultTrinkets.hidden("dmg_lava_100")), "Ring of Coolness", "Reduce all heat related damage (100%)");
        DefaultTrinkets.register("nightvision_ring", DefaultTrinkets.trinket("nightvision_ring", "gold_ring", DefaultTrinkets.effect("night_vision_hotkey")), "Night Vision", "Using a hotkey you can see clearly in the dark");
        DefaultTrinkets.register("stepassist_ring", DefaultTrinkets.trinket("stepassist_ring", "gold_ring", DefaultTrinkets.effect("step_assist")), "Step Assist Ring", "You can move around much easier now");
        DefaultTrinkets.register("grow_charm", DefaultTrinkets.trinket("grow_charm", "charm1", DefaultTrinkets.effect("growtick")), "Charm of Growth", "Crops grow faster around you");
        DefaultTrinkets.register("base_heart", DefaultTrinkets.trinket("base_heart", "heart", new TrinketDescription.EffectRef[0]), "Base Heart", "Crafting ingredient to make heart trinkets");
        DefaultTrinkets.register("super_health", DefaultTrinkets.trinket("super_health", "heart_body", DefaultTrinkets.effect("regeneration"), DefaultTrinkets.effect("max_health")), "Heart of Health", "You feel so much more healthy now");
        DefaultTrinkets.register("cure", DefaultTrinkets.trinket("cure", "heart", DefaultTrinkets.effect("cure")), "Heart of Curing", "Negative effects can't harm you");
        DefaultTrinkets.register("base_gold_ring_diamond", DefaultTrinkets.trinket("base_gold_ring_diamond", "gold_ring_diamond", new TrinketDescription.EffectRef[0]), "Base Golden Ring with Diamond", "Crafting ingredient to make golden ring trinkets (with diamond)");
        DefaultTrinkets.register("absorption_ring", DefaultTrinkets.trinket("absorption_ring", "gold_ring_diamond", DefaultTrinkets.effect("absorption")), "Ring of Absorption", "Provides some damage absorption");
        DefaultTrinkets.register("regeneration_ring", DefaultTrinkets.trinket("regeneration_ring", "gold_ring_diamond", DefaultTrinkets.effect("regeneration")), "Regeneration Ring", "Slowly get your health back");
        DefaultTrinkets.register("strength_ring", DefaultTrinkets.trinket("strength_ring", "gold_ring_diamond", DefaultTrinkets.effect("strength")), "Strength Ring", "Your attacks seem to have more effect");
        DefaultTrinkets.register("warp_pearl", DefaultTrinkets.trinket("warp_pearl", "blue_pearl", DefaultTrinkets.effect("warp")), "Warp Pearl", "Warp Pearl");
        DefaultTrinkets.register("shiny", DefaultTrinkets.trinket("shiny", "silver_ring_diamond", DefaultTrinkets.effect("shiny")), "Shiny", "Diamonds are so shiny!");
    }

    private static TrinketDescription.EffectRef effect(String id) {
        return new TrinketDescription.EffectRef(new ResourceLocation("fancytrinkets", id), false);
    }

    private static TrinketDescription.EffectRef hidden(String id) {
        return new TrinketDescription.EffectRef(new ResourceLocation("fancytrinkets", id), true);
    }

    private static void register(String id, TrinketDescription trinket, String name, String description) {
        DEFAULT_TRINKETS.put(new ResourceLocation("fancytrinkets", id), new TrinketInfo(trinket, name, description));
    }

    private static TrinketDescription trinket(String id, String itemId, TrinketDescription.EffectRef ... effects) {
        return new TrinketDescription(new ResourceLocation("fancytrinkets", itemId), new ResourceLocation("fancytrinkets", "standard"), "trinket.fancytrinkets." + id + ".name", "trinket.fancytrinkets." + id + ".description", List.of(effects));
    }

    public record TrinketInfo(TrinketDescription trinketDescription, String name, String description) {
    }
}

