/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.loot;

import com.mcjty.fancytrinkets.datapack.CustomRegistries;
import com.mcjty.fancytrinkets.datapack.TrinketDescription;
import com.mcjty.fancytrinkets.modules.loot.TrinketLootEntry;
import com.mcjty.fancytrinkets.modules.trinkets.items.TrinketItemData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mcjty.lib.varia.Tools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class TrinketLootModifier
extends LootModifier {
    private final List<ResourceLocation> trinketIds;
    private final float chance;
    private final int min;
    private final int max;
    private final float lootingFactor;
    private final float minQuality;
    private final float maxQuality;
    private final Set<String> tags;
    public static final Codec<TrinketLootModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(l -> l.conditions), (App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("trinkets").forGetter(l -> l.trinketIds), (App)Codec.FLOAT.fieldOf("chance").forGetter(l -> Float.valueOf(l.chance)), (App)Codec.INT.fieldOf("min").forGetter(l -> l.min), (App)Codec.INT.fieldOf("max").forGetter(l -> l.max), (App)Codec.FLOAT.fieldOf("looting").forGetter(l -> Float.valueOf(l.lootingFactor)), (App)Codec.FLOAT.fieldOf("minquality").forGetter(l -> Float.valueOf(l.minQuality)), (App)Codec.FLOAT.fieldOf("maxquality").forGetter(l -> Float.valueOf(l.maxQuality)), (App)Codec.STRING.listOf().optionalFieldOf("tags").forGetter(l -> l.tags.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(l.tags)))).apply((Applicative)instance, TrinketLootModifier::new));

    public TrinketLootModifier(LootItemCondition[] conditionsIn, List<ResourceLocation> trinketIds, float chance, int min, int max, float looting, float minQuality, float maxQuality, Optional<List<String>> tags) {
        super(conditionsIn);
        this.trinketIds = trinketIds;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.lootingFactor = looting;
        this.minQuality = minQuality;
        this.maxQuality = maxQuality;
        this.tags = Set.copyOf(tags.orElse(Collections.emptyList()));
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation id;
        Entity entity;
        RandomSource random = context.m_230907_();
        if (!this.tags.isEmpty() && (entity = (Entity)context.m_78953_(LootContextParams.f_81455_)) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TrinketLootEntry.generateTrinketLootEffect(arg_0 -> generatedLoot.add(arg_0), random, player, this.tags);
        }
        if (this.trinketIds.isEmpty()) {
            List<ResourceLocation> keys = Tools.getRegistryAccess((Level)context.m_78952_()).m_175515_(CustomRegistries.TRINKET_REGISTRY_KEY).m_6579_().stream().map(p -> ((ResourceKey)p.getKey()).m_135782_()).toList();
            if (keys.isEmpty()) {
                return generatedLoot;
            }
            id = keys.get(random.m_188503_(keys.size()));
        } else {
            id = this.trinketIds.get(random.m_188503_(this.trinketIds.size()));
        }
        TrinketDescription trinket = (TrinketDescription)Tools.getRegistryAccess((Level)context.m_78952_()).m_175515_(CustomRegistries.TRINKET_REGISTRY_KEY).m_7745_(id);
        if (trinket == null) {
            return generatedLoot;
        }
        Item it = Tools.getItem((ResourceLocation)trinket.item());
        if (it == null) {
            return generatedLoot;
        }
        if (random.m_188501_() < this.chance + (float)context.getLootingModifier() * this.lootingFactor) {
            int cnt = this.max <= this.min ? this.min : random.m_188503_(this.max - this.min + 1) + this.min;
            cnt += random.m_188503_(context.getLootingModifier() + 1);
            while (cnt > 0) {
                ItemStack stack = TrinketItemData.createTrinketStack((Level)context.m_78952_(), trinket, id, random.m_188501_() * (this.maxQuality - this.minQuality) + this.minQuality);
                generatedLoot.add((Object)stack);
                --cnt;
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

