/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mcjty.fancytrinkets.modules.effects.imp.TrinketLootEffect;
import com.mcjty.fancytrinkets.modules.loot.LootModule;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class TrinketLootEntry
extends LootPoolSingletonContainer {
    private final Set<String> tags;

    public TrinketLootEntry(int weightIn, int qualityIn, LootItemCondition[] conditionsIn, LootItemFunction[] functionsIn, Set<String> tags) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
        this.tags = tags;
    }

    protected void m_6948_(@Nonnull Consumer<ItemStack> stackConsumer, @Nonnull LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TrinketLootEntry.generateTrinketLootEffect(stackConsumer, context.m_230907_(), player, this.tags);
        }
    }

    public static void generateTrinketLootEffect(@NotNull Consumer<ItemStack> stackConsumer, @NotNull RandomSource random, ServerPlayer player, Set<String> tags) {
        for (SlotResult slot : CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, stack -> stack.getCapability(Registration.TRINKET_ITEM_CAPABILITY).isPresent())) {
            ItemStack stack2 = slot.stack();
            stack2.getCapability(Registration.TRINKET_ITEM_CAPABILITY).ifPresent(trinket -> {
                Set<String> activeToggles = trinket.getActiveToggles();
                trinket.forAllEffects(player.m_9236_(), stack2, (effect, idx) -> {
                    if (effect instanceof TrinketLootEffect) {
                        Set<String> trinketTags;
                        TrinketLootEffect trinketLootEffect = (TrinketLootEffect)effect;
                        String toggle = effect.getToggle();
                        if ((toggle == null || activeToggles.contains(toggle)) && !Collections.disjoint(tags, trinketTags = trinketLootEffect.getTags())) {
                            trinketLootEffect.generateLoot(stackConsumer, random);
                        }
                    }
                });
            });
        }
    }

    @Nonnull
    public LootPoolEntryType m_6751_() {
        return LootModule.TRINKET_LOOT_ENTRY.get();
    }

    public static LootPoolSingletonContainer.Builder<?> builder(Set<String> tags) {
        return TrinketLootEntry.m_79687_((weight, quality, conditions, functions) -> new TrinketLootEntry(weight, quality, conditions, functions, tags));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<TrinketLootEntry> {
        public void serializeCustom(@Nonnull JsonObject object, @Nonnull TrinketLootEntry entry, @Nonnull JsonSerializationContext conditions) {
            super.m_7219_(object, (LootPoolSingletonContainer)entry, conditions);
            JsonArray array = new JsonArray();
            entry.tags.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            object.add("tags", (JsonElement)array);
        }

        @Nonnull
        protected TrinketLootEntry deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext context, int weight, int quality, @Nonnull LootItemCondition[] conditions, @Nonnull LootItemFunction[] functions) {
            HashSet<String> tags = new HashSet<String>();
            JsonArray array = object.getAsJsonArray("tags");
            array.forEach(element -> tags.add(element.getAsString()));
            return new TrinketLootEntry(weight, quality, conditions, functions, tags);
        }
    }
}

