/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.loot;

import com.mcjty.fancytrinkets.FancyTrinkets;
import com.mcjty.fancytrinkets.modules.loot.EssenceLootModifier;
import com.mcjty.fancytrinkets.modules.loot.TrinketLootEntry;
import com.mcjty.fancytrinkets.modules.loot.TrinketLootModifier;
import com.mcjty.fancytrinkets.setup.Registration;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.lib.setup.DeferredItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class LootModule
implements IModule {
    public static final Map<String, Essence> ESSENCE_ITEMS = new HashMap<String, Essence>();
    public static final Map<String, EssenceGLM> ESSENCE_GLMS = new HashMap<String, EssenceGLM>();
    public static final DeferredItem<Item> ZOMBIE_ESSENCE = LootModule.createBasicItem("zombie_essence", "item/essence/zombie_essence", "Zombie Essence");
    public static final DeferredItem<Item> WITHER_SKELETON_ESSENCE = LootModule.createBasicItem("wither_skeleton_essence", "item/essence/wither_skeleton_essence", "Wither Skeleton Essence");
    public static final DeferredItem<Item> WITHER_ESSENCE = LootModule.createBasicItem("wither_essence", "item/essence/wither_essence", "Wither Essence");
    public static final DeferredItem<Item> SKELETON_ESSENCE = LootModule.createBasicItem("skeleton_essence", "item/essence/skeleton_essence", "Skeleton Essence");
    public static final DeferredItem<Item> DRAGON_ESSENCE = LootModule.createBasicItem("dragon_essence", "item/essence/dragon_essence", "Enderdragon Essence");
    public static final DeferredItem<Item> ENDERMAN_ESSENCE = LootModule.createBasicItem("enderman_essence", "item/essence/enderman_essence", "Enderman Essence");
    public static final DeferredItem<Item> GHAST_ESSENCE = LootModule.createBasicItem("ghast_essence", "item/essence/ghast_essence", "Ghast Essence");
    public static final DeferredItem<Item> SPIDER_ESSENCE = LootModule.createBasicItem("spider_essence", "item/essence/spider_essence", "Spider Essence");
    public static final DeferredItem<Item> CHICKEN_ESSENCE = LootModule.createBasicItem("chicken_essence", "item/essence/chicken_essence", "Chicken Essence");
    public static final DeferredItem<Item> IRON_GOLEM_ESSENCE = LootModule.createBasicItem("iron_golem_essence", "item/essence/iron_golem_essence", "Iron Golem Essence");
    public static final DeferredItem<Item> BLAZE_ESSENCE = LootModule.createBasicItem("blaze_essence", "item/essence/blaze_essence", "Blaze Essence");
    public static final Supplier<Codec<? extends IGlobalLootModifier>> ESSENCE_LOOT_MODIFIER = Registration.LOOT_MODIFIER_SERIALIZERS.register("essence_loot", () -> EssenceLootModifier.CODEC);
    public static final Supplier<Codec<? extends IGlobalLootModifier>> TRINKET_LOOT_MODIFIER = Registration.LOOT_MODIFIER_SERIALIZERS.register("trinket_loot", () -> TrinketLootModifier.CODEC);
    public static final EssenceGLM ZOMBIE_LOOT_MODIFIER = LootModule.createGlm("zombie_essence", EntityType.f_20501_, 0.1f, 1, 2, 0.3f);
    public static final EssenceGLM WITHER_SKELETON_LOOT_MODIFIER = LootModule.createGlm("wither_skeleton_essence", EntityType.f_20497_, 0.1f, 1, 2, 0.3f);
    public static final EssenceGLM WITHER_LOOT_MODIFIER = LootModule.createGlm("wither_essence", EntityType.f_20496_, 1.0f, 1, 2, 0.3f);
    public static final EssenceGLM SKELETON_LOOT_MODIFIER = LootModule.createGlm("skeleton_essence", EntityType.f_20524_, 0.1f, 1, 2, 0.3f);
    public static final EssenceGLM DRAGON_LOOT_MODIFIER = LootModule.createGlm("dragon_essence", EntityType.f_20565_, 1.0f, 4, 7, 0.3f);
    public static final EssenceGLM ENDERMAN_LOOT_MODIFIER = LootModule.createGlm("enderman_essence", EntityType.f_20566_, 0.1f, 1, 2, 0.3f);
    public static final EssenceGLM GHAST_LOOT_MODIFIER = LootModule.createGlm("ghast_essence", EntityType.f_20453_, 0.4f, 1, 2, 0.3f);
    public static final EssenceGLM SPIDER_LOOT_MODIFIER = LootModule.createGlm("spider_essence", EntityType.f_20479_, 0.1f, 1, 1, 0.3f);
    public static final EssenceGLM CHICKEN_LOOT_MODIFIER = LootModule.createGlm("chicken_essence", EntityType.f_20555_, 0.1f, 1, 1, 0.3f);
    public static final EssenceGLM IRON_GOLEM_LOOT_MODIFIER = LootModule.createGlm("iron_golem_essence", EntityType.f_20460_, 0.3f, 1, 2, 0.3f);
    public static final EssenceGLM BLAZE_LOOT_MODIFIER = LootModule.createGlm("blaze_essence", EntityType.f_20551_, 0.3f, 1, 2, 0.3f);
    public static final Supplier<LootPoolEntryType> TRINKET_LOOT_ENTRY = Registration.LOOT_POOL_ENTRIES.register("trinket_loot", () -> new LootPoolEntryType((Serializer)new TrinketLootEntry.Serializer()));

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
    }

    public void initConfig(IEventBus bus) {
    }

    public void initDatagen(DataGen dataGen) {
        ResourceLocation[] otherChests;
        ResourceLocation[] resourceLocationArray;
        for (Map.Entry<String, Essence> entry : ESSENCE_ITEMS.entrySet()) {
            Essence essence = entry.getValue();
            dataGen.add(new Dob.Builder[]{Dob.itemBuilder(essence.item()).name(essence.description()).generatedItem(essence.texture())});
        }
        for (Map.Entry<String, Record> entry : ESSENCE_GLMS.entrySet()) {
            ResourceLocation[] glm = (ResourceLocation[])entry.getValue();
            dataGen.add(new Dob.Builder[]{Dob.builder().glm(entry.getKey(), () -> LootModule.lambda$initDatagen$3((EssenceGLM)glm))});
        }
        dataGen.add(new Dob.Builder[]{Dob.builder().glm("wither_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)EntityType.f_20496_.m_20677_()).m_6409_()}, List.of(new ResourceLocation("fancytrinkets", "regeneration_ring")), 0.5f, 1, 1, 0.0f, 60.0f, 70.0f, Optional.empty())).glm("dragon_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)EntityType.f_20565_.m_20677_()).m_6409_()}, List.of(new ResourceLocation("fancytrinkets", "power_star")), 1.0f, 1, 1, 0.0f, 90.0f, 100.0f, Optional.empty())).glm("enderman_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)EntityType.f_20566_.m_20677_()).m_6409_()}, List.of(new ResourceLocation("fancytrinkets", "warp_pearl")), 0.02f, 1, 1, 0.0f, 90.0f, 100.0f, Optional.empty()))});
        Optional<List<String>> shinyTags = Optional.of(List.of("shiny"));
        for (ResourceLocation chest : resourceLocationArray = new ResourceLocation[]{BuiltInLootTables.f_78741_, BuiltInLootTables.f_78761_, BuiltInLootTables.f_78764_, BuiltInLootTables.f_78689_, BuiltInLootTables.f_78697_, BuiltInLootTables.f_230876_}) {
            dataGen.add(new Dob.Builder[]{Dob.builder().glm(chest.m_135815_() + "_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)chest).m_6409_()}, Collections.emptyList(), 0.1f, 1, 1, 0.0f, 20.0f, 70.0f, shinyTags))});
        }
        for (ResourceLocation chest : otherChests = new ResourceLocation[]{BuiltInLootTables.f_78742_, BuiltInLootTables.f_78746_, BuiltInLootTables.f_78753_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78760_, BuiltInLootTables.f_78762_, BuiltInLootTables.f_78763_, BuiltInLootTables.f_78686_, BuiltInLootTables.f_78687_, BuiltInLootTables.f_78688_, BuiltInLootTables.f_78690_, BuiltInLootTables.f_78691_, BuiltInLootTables.f_78692_, BuiltInLootTables.f_78693_, BuiltInLootTables.f_78694_, BuiltInLootTables.f_78695_, BuiltInLootTables.f_78696_, BuiltInLootTables.f_78698_, BuiltInLootTables.f_78699_, BuiltInLootTables.f_78700_, BuiltInLootTables.f_230877_, BuiltInLootTables.f_78701_}) {
            dataGen.add(new Dob.Builder[]{Dob.builder().glm(chest.m_135815_() + "_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)chest).m_6409_()}, Collections.emptyList(), 0.02f, 1, 1, 0.0f, 5.0f, 10.0f, shinyTags))});
        }
    }

    @Nonnull
    private static DeferredItem<Item> createBasicItem(String id, String texture, String description) {
        DeferredItem object = Registration.ITEMS.register(id, FancyTrinkets.tab(() -> new Item(FancyTrinkets.setup.defaultProperties().m_41487_(64))));
        ESSENCE_ITEMS.put(id, new Essence((DeferredItem<Item>)object, texture, description));
        return object;
    }

    private static EssenceGLM createGlm(String id, EntityType<?> type, float chance, int min, int max, float looting) {
        EssenceGLM glm = new EssenceGLM(new ResourceLocation("fancytrinkets", id), type.m_20677_(), chance, min, max, looting);
        ESSENCE_GLMS.put(id, glm);
        return glm;
    }

    private static /* synthetic */ IGlobalLootModifier lambda$initDatagen$3(EssenceGLM glm) {
        return new EssenceLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)glm.lootTable()).m_6409_(), LootItemKilledByPlayerCondition.m_81901_().m_6409_()}, glm.itemId(), glm.chance(), glm.min(), glm.max(), glm.looting());
    }

    public record Essence(DeferredItem<Item> item, String texture, String description) {
    }

    public record EssenceGLM(ResourceLocation itemId, ResourceLocation lootTable, float chance, int min, int max, float looting) {
    }
}

