/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import mcjty.lib.varia.Tools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class EssenceLootModifier
extends LootModifier {
    private final ResourceLocation item;
    private final float chance;
    private final int min;
    private final int max;
    private final float lootingFactor;
    public static final Codec<EssenceLootModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(l -> l.conditions), (App)ResourceLocation.f_135803_.fieldOf("item").forGetter(l -> l.item), (App)Codec.FLOAT.fieldOf("chance").forGetter(l -> Float.valueOf(l.chance)), (App)Codec.INT.fieldOf("min").forGetter(l -> l.min), (App)Codec.INT.fieldOf("max").forGetter(l -> l.max), (App)Codec.FLOAT.fieldOf("looting").forGetter(l -> Float.valueOf(l.lootingFactor))).apply((Applicative)instance, EssenceLootModifier::new));

    public EssenceLootModifier(LootItemCondition[] conditionsIn, ResourceLocation item, float chance, int min, int max, float looting) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.lootingFactor = looting;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Item it = Tools.getItem((ResourceLocation)this.item);
        if (it == null) {
            return generatedLoot;
        }
        RandomSource random = context.m_230907_();
        if (random.m_188501_() < this.chance + (float)context.getLootingModifier() * this.lootingFactor) {
            int cnt = this.max <= this.min ? this.min : random.m_188503_(this.max - this.min + 1) + this.min;
            cnt += random.m_188503_(context.getLootingModifier() + 1);
            while (cnt > 0) {
                generatedLoot.add((Object)new ItemStack((ItemLike)it));
                --cnt;
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

