/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mcjty.lib.varia.SoundTools;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class WarpEffect
extends EffectImp {
    private final int maxdist;
    public static final Codec<IEffectParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("maxdist").forGetter(l -> ((Params)l).maxdist)).apply((Applicative)instance, Params::new));

    public WarpEffect(Integer hotkey, String toggle, int maxdist) {
        super(hotkey, toggle);
        this.maxdist = maxdist;
    }

    @Override
    public void onHotkey(ItemStack stack, ServerPlayer player, String slotId, int key) {
        if (Objects.equals(key, this.hotkey)) {
            this.executeIfEnabled(player, () -> {
                Vec3 lookVec = player.m_20154_();
                Vec3 start = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
                int distance = this.maxdist;
                boolean gothrough = false;
                if (player.m_6144_()) {
                    distance /= 2;
                }
                Vec3 end = start.m_82520_(lookVec.f_82479_ * (double)distance, lookVec.f_82480_ * (double)distance, lookVec.f_82481_ * (double)distance);
                ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
                BlockHitResult position = player.m_9236_().m_45547_(context);
                this.safeTeleport(player, position);
            });
        }
    }

    private void safeTeleport(ServerPlayer player, BlockHitResult position) {
        Level level = player.m_9236_();
        BlockPos blockPos = position.m_82425_();
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        if (level.m_46859_(blockPos.m_7494_()) && level.m_46859_(blockPos.m_6630_(2))) {
            player.m_6021_((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        } else {
            switch (position.m_82434_()) {
                case DOWN: {
                    player.m_6021_((double)x + 0.5, (double)(y - 2), (double)z + 0.5);
                    break;
                }
                case UP: {
                    return;
                }
                case NORTH: {
                    player.m_6021_((double)x + 0.5, (double)y, (double)(z - 1) + 0.5);
                    break;
                }
                case SOUTH: {
                    player.m_6021_((double)x + 0.5, (double)y, (double)(z + 1) + 0.5);
                    break;
                }
                case WEST: {
                    player.m_6021_((double)(x - 1) + 0.5, (double)y, (double)z + 0.5);
                    break;
                }
                case EAST: {
                    player.m_6021_((double)(x + 1) + 0.5, (double)y, (double)z + 0.5);
                }
            }
        }
        SoundTools.playSound((Level)player.m_20193_(), (SoundEvent)SoundEvents.f_11857_, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)1.0, (double)1.0);
    }

    public record Params(int maxdist) implements IEffectParameters
    {
        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.WARP;
        }

        public static Params cast(IEffectParameters params) {
            if (params instanceof Params) {
                Params p = (Params)params;
                return p;
            }
            throw new RuntimeException("Bad parameter type!");
        }
    }
}

