/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public class TrinketLootEffect
extends EffectImp {
    public static final Codec<Loot> LOOT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("stack").forGetter(l -> l.stack), (App)Codec.FLOAT.fieldOf("chance").forGetter(l -> Float.valueOf(l.chance)), (App)Codec.INT.fieldOf("min").forGetter(l -> l.min), (App)Codec.INT.fieldOf("max").forGetter(l -> l.max)).apply((Applicative)instance, Loot::new));
    private final Set<String> tags;
    private final List<Loot> loot;
    public static final Codec<IEffectParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("tags").forGetter(l -> new ArrayList<String>(((Params)l).tags)), (App)LOOT_CODEC.listOf().fieldOf("loot").forGetter(l -> ((Params)l).loot)).apply((Applicative)instance, (strings, loots) -> new Params(Set.copyOf(strings), List.copyOf(loots))));

    public TrinketLootEffect(Integer hotkey, String toggle, Set<String> tags, List<Loot> loot) {
        super(hotkey, toggle);
        this.tags = tags;
        this.loot = loot;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void generateLoot(@Nonnull Consumer<ItemStack> stackConsumer, RandomSource source) {
        this.loot.forEach(loot -> {
            if (source.m_188501_() < loot.chance()) {
                int amount = loot.min() + source.m_188503_(loot.max() - loot.min() + 1);
                ItemStack stack = loot.stack().m_41777_();
                stack.m_41764_(amount);
                stackConsumer.accept(stack);
            }
        });
    }

    @Override
    public void tick(ItemStack stack, ServerPlayer player, String slotId) {
    }

    public record Loot(ItemStack stack, float chance, int min, int max) {
    }

    public record Params(Set<String> tags, List<Loot> loot) implements IEffectParameters
    {
        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.TRINKETLOOT;
        }

        public static Params cast(IEffectParameters params) {
            if (params instanceof Params) {
                Params p = (Params)params;
                return p;
            }
            throw new RuntimeException("Bad parameter type!");
        }
    }
}

