/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mcjty.fancytrinkets.playerdata.PlayerEffects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class MobEffectEffect
extends EffectImp {
    private final MobEffect effect;
    private final int strengthModifier;
    public static final Codec<IEffectParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("effectId").forGetter(l -> ((Params)l).effect), (App)Codec.INT.fieldOf("strength").forGetter(l -> ((Params)l).strength)).apply((Applicative)instance, Params::new));

    public MobEffectEffect(Integer hotkey, String toggle, MobEffect effect, int strengthModifier) {
        super(hotkey, toggle);
        this.effect = effect;
        this.strengthModifier = strengthModifier;
    }

    @Override
    public void tick(ItemStack stack, ServerPlayer player, String slotId) {
        this.executeIfEnabled(player, (PlayerEffects playerEffects) -> {
            long gameTime = player.m_9236_().m_46467_();
            playerEffects.registerEffect(slotId, this, gameTime + 280L);
        });
    }

    @Override
    public void onUnequip(ItemStack stack, ServerPlayer player, String slotId) {
        player.getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(playerEffects -> playerEffects.unregisterEffect(slotId));
        this.turnOff(player);
    }

    @Override
    public void onHotkey(ItemStack stack, ServerPlayer player, String slotId, int key) {
        if (this.toggle != null && Objects.equals(key, this.hotkey)) {
            player.getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(playerEffects -> {
                if (!playerEffects.toggle(player, this.toggle)) {
                    playerEffects.unregisterEffect(slotId);
                    this.turnOff(player);
                }
            });
        }
    }

    @Override
    protected void turnOff(ServerPlayer player) {
        MobEffectInstance instance = (MobEffectInstance)player.m_21221_().get(this.effect);
        if (instance != null) {
            player.m_21195_(instance.m_19544_());
        }
    }

    @Override
    public void perform(ServerPlayer player, int strength) {
        MobEffectInstance instance = (MobEffectInstance)player.m_21221_().get(this.effect);
        int amplifier = this.strengthModifier + strength - 1;
        if (instance == null || instance.m_19564_() != amplifier || instance.m_19557_() < 220) {
            player.m_7292_(new MobEffectInstance(this.effect, 280, amplifier));
        }
    }

    public record Params(String effect, int strength) implements IEffectParameters
    {
        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.MOBEFFECT;
        }

        public static Params cast(IEffectParameters params) {
            if (params instanceof Params) {
                Params p = (Params)params;
                return p;
            }
            throw new RuntimeException("Bad parameter type!");
        }
    }
}

