/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.modules.effects.IEffect;
import com.mcjty.fancytrinkets.playerdata.PlayerEffects;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class EffectImp
implements IEffect {
    protected final Integer hotkey;
    protected final String toggle;

    public EffectImp(Integer hotkey, String toggle) {
        this.hotkey = hotkey;
        this.toggle = toggle;
    }

    protected void executeIfEnabled(ServerPlayer player, Consumer<PlayerEffects> runnable) {
        player.getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(playerEffects -> {
            if (this.toggle != null && !playerEffects.isToggleOn(this.toggle)) {
                return;
            }
            runnable.accept((PlayerEffects)playerEffects);
        });
    }

    protected void executeIfEnabled(ServerPlayer player, Runnable runnable) {
        if (this.toggle != null) {
            player.getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(playerEffects -> {
                if (!playerEffects.isToggleOn(this.toggle)) {
                    return;
                }
                runnable.run();
            });
        } else {
            runnable.run();
        }
    }

    @Override
    public void onUnequip(ItemStack stack, ServerPlayer player, String slotId) {
        this.turnOff(player);
    }

    @Override
    public void onHotkey(ItemStack stack, ServerPlayer player, String slotId, int key) {
        if (this.toggle != null && Objects.equals(key, this.hotkey)) {
            player.getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(playerEffects -> {
                if (!playerEffects.toggle(player, this.toggle)) {
                    this.turnOff(player);
                }
            });
        }
    }

    protected void turnOff(ServerPlayer player) {
    }

    @Override
    public Integer getHotkey() {
        return this.hotkey;
    }

    @Override
    public String getToggle() {
        return this.toggle;
    }
}

