/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mcjty.fancytrinkets.playerdata.PlayerEffects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class DamageReductionEffect
extends EffectImp {
    private final String dmgId;
    private final float factor;
    public static final Codec<IEffectParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("damage").forGetter(l -> ((Params)l).dmgId), (App)Codec.FLOAT.fieldOf("factor").forGetter(l -> Float.valueOf(((Params)l).factor))).apply((Applicative)instance, Params::new));

    public DamageReductionEffect(Integer hotkey, String toggle, String dmgId, float factor) {
        super(hotkey, toggle);
        this.dmgId = dmgId;
        this.factor = factor;
    }

    @Override
    public void tick(ItemStack stack, ServerPlayer player, String slotId) {
        this.executeIfEnabled(player, (PlayerEffects playerEffects) -> playerEffects.registerDamageReduction(this.dmgId, this.factor));
    }

    @Override
    protected void turnOff(ServerPlayer player) {
        player.getCapability(PlayerEffects.PLAYER_EFFECTS).ifPresent(playerEffects -> playerEffects.unregisterDamageReduction(this.dmgId));
    }

    public record Params(String dmgId, float factor) implements IEffectParameters
    {
        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.DAMAGEREDUCTION;
        }

        public static Params cast(IEffectParameters params) {
            if (params instanceof Params) {
                Params p = (Params)params;
                return p;
            }
            throw new RuntimeException("Bad parameter type!");
        }
    }
}

