/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class AttributeModifierEffect
extends EffectImp {
    private final UUID uuid;
    private final AttributeModifier modifier;
    private final Supplier<Attribute> attribute;
    public static final Codec<IEffectParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("effectId").forGetter(l -> ((Params)l).effect), (App)Codec.STRING.fieldOf("operation").forGetter(l -> ((Params)l).operation.name().toLowerCase()), (App)Codec.DOUBLE.fieldOf("amount").forGetter(l -> ((Params)l).amount)).apply((Applicative)instance, (effect, operation, amount) -> new Params((String)effect, AttributeModifier.Operation.valueOf((String)operation.toUpperCase()), (Double)amount)));

    public AttributeModifierEffect(Integer hotkey, String toggle, String name, Supplier<Attribute> attibute, AttributeModifier.Operation operation, double amount) {
        super(hotkey, toggle);
        this.attribute = attibute;
        this.uuid = UUID.randomUUID();
        this.modifier = new AttributeModifier(this.uuid, name, amount, operation);
    }

    @Override
    public void tick(ItemStack stack, ServerPlayer player, String slotId) {
        if (!player.m_7500_()) {
            this.executeIfEnabled(player, () -> {
                AttributeInstance instance = player.m_21051_(this.attribute.get());
                if (instance != null && instance.m_22111_(this.uuid) == null) {
                    instance.m_22118_(this.modifier);
                }
            });
        }
    }

    @Override
    protected void turnOff(ServerPlayer player) {
        AttributeInstance instance;
        if (!player.m_7500_() && (instance = player.m_21051_(this.attribute.get())) != null) {
            instance.m_22120_(this.uuid);
        }
    }

    public record Params(String effect, AttributeModifier.Operation operation, Double amount) implements IEffectParameters
    {
        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.ATTRIBUTE;
        }

        public static Params cast(IEffectParameters params) {
            if (params instanceof Params) {
                Params p = (Params)params;
                return p;
            }
            throw new RuntimeException("Bad parameter type!");
        }
    }
}

