/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.datapack;

import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.IEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.AttributeModifierEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.CureEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.DamageReductionEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.FlightEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.GrowTickEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.MobEffectEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.PotionResistanceEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.TrinketLootEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.WarpEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Tools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;

public record EffectDescription(Integer hotkey, String toggle, boolean harmful, IEffectParameters params, IEffect effect) {
    public static final Codec<IEffectParameters> PARAMS_CODEC = ExtraCodecs.m_184415_(() -> Codec.STRING.dispatch("type", s -> s.getType().name().toLowerCase(), EffectDescription::getParameterCodec));
    public static final Codec<EffectDescription> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("hotkey").forGetter(l -> Optional.ofNullable(l.hotkey)), (App)Codec.STRING.optionalFieldOf("toggle").forGetter(l -> Optional.ofNullable(l.toggle)), (App)Codec.BOOL.optionalFieldOf("harmful").forGetter(l -> l.harmful ? Optional.of(l.harmful) : Optional.empty()), (App)PARAMS_CODEC.fieldOf("params").forGetter(l -> l.params)).apply((Applicative)instance, (hotkey, toggle, harmful, params) -> EffectDescription.create(hotkey.orElse(null), toggle.orElse(null), harmful.orElse(false), params)));

    public static EffectDescription create(Integer hotkey, String toggle, boolean harmful, IEffectParameters params) {
        return new EffectDescription(hotkey, toggle, harmful, params, EffectDescription.buildEffect(params, hotkey, toggle));
    }

    private static Codec<IEffectParameters> getParameterCodec(String stype) {
        EffectType type = EffectType.valueOf(stype.toUpperCase());
        return type.getCodecSupplier().get();
    }

    private static IEffect buildEffect(IEffectParameters params, Integer hotkey, String toggle) {
        return switch (params.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case EffectType.MOBEFFECT -> EffectDescription.getMobEffectEffect(params, hotkey, toggle);
            case EffectType.POTIONRESISTANCE -> EffectDescription.getPotionResistanceEffect(params, hotkey, toggle);
            case EffectType.DAMAGEREDUCTION -> EffectDescription.getDamageReductionEffect(params, hotkey, toggle);
            case EffectType.FLIGHT -> new FlightEffect(hotkey, toggle);
            case EffectType.WARP -> new WarpEffect(hotkey, toggle, WarpEffect.Params.cast(params).maxdist());
            case EffectType.CURE -> new CureEffect(hotkey, toggle);
            case EffectType.ATTRIBUTE -> EffectDescription.getAttributeEffect(params, hotkey, toggle);
            case EffectType.GROWTICK -> EffectDescription.getGrowTickEffect(params, hotkey, toggle);
            case EffectType.TRINKETLOOT -> new TrinketLootEffect(hotkey, toggle, TrinketLootEffect.Params.cast(params).tags(), TrinketLootEffect.Params.cast(params).loot());
        };
    }

    @Nonnull
    private static GrowTickEffect getGrowTickEffect(IEffectParameters params, Integer hotkey, String toggle) {
        GrowTickEffect.Params p = GrowTickEffect.Params.cast(params);
        return new GrowTickEffect(hotkey, toggle, p.maxdist(), p.blocks());
    }

    @Nonnull
    private static AttributeModifierEffect getAttributeEffect(IEffectParameters params, Integer hotkey, String toggle) {
        String effName;
        AttributeModifierEffect.Params p = AttributeModifierEffect.Params.cast(params);
        Object attributeSupplier = switch (effName = p.effect()) {
            case "step_assist" -> ForgeMod.STEP_HEIGHT_ADDITION;
            case "swim_speed" -> ForgeMod.SWIM_SPEED;
            case "attack_range" -> ForgeMod.ENTITY_REACH;
            case "reach_distance" -> ForgeMod.BLOCK_REACH;
            case "max_health" -> () -> Attributes.f_22276_;
            case "knockback_resistance" -> () -> Attributes.f_22278_;
            case "movement_speed" -> () -> Attributes.f_22279_;
            case "attack_speed" -> () -> Attributes.f_22283_;
            case "attack_damage" -> () -> Attributes.f_22281_;
            case "luck" -> () -> Attributes.f_22286_;
            default -> throw new RuntimeException("Bad attribute effectId '" + effName + "'!");
        };
        return new AttributeModifierEffect(hotkey, toggle, effName, (Supplier<Attribute>)attributeSupplier, p.operation(), p.amount());
    }

    @Nonnull
    private static MobEffectEffect getMobEffectEffect(IEffectParameters params, Integer hotkey, String toggle) {
        MobEffectEffect.Params p = MobEffectEffect.Params.cast(params);
        String effName = p.effect();
        MobEffect effect = Tools.getEffect((ResourceLocation)new ResourceLocation(effName));
        if (effect == null) {
            throw new RuntimeException("Can't find effectId '" + effName + "'!");
        }
        return new MobEffectEffect(hotkey, toggle, effect, p.strength() - 1);
    }

    @Nonnull
    private static PotionResistanceEffect getPotionResistanceEffect(IEffectParameters params, Integer hotkey, String toggle) {
        PotionResistanceEffect.Params p = PotionResistanceEffect.Params.cast(params);
        String effName = p.effect();
        MobEffect effect = Tools.getEffect((ResourceLocation)new ResourceLocation(effName));
        if (effect == null) {
            throw new RuntimeException("Can't find effectId '" + effName + "'!");
        }
        return new PotionResistanceEffect(hotkey, toggle, effect);
    }

    @Nonnull
    private static DamageReductionEffect getDamageReductionEffect(IEffectParameters params, Integer hotkey, String toggle) {
        DamageReductionEffect.Params p = DamageReductionEffect.Params.cast(params);
        String dmgId = p.dmgId();
        float factor = p.factor();
        return new DamageReductionEffect(hotkey, toggle, dmgId, factor);
    }

    public static enum EffectType {
        MOBEFFECT(() -> MobEffectEffect.CODEC),
        POTIONRESISTANCE(() -> PotionResistanceEffect.CODEC),
        DAMAGEREDUCTION(() -> DamageReductionEffect.CODEC),
        FLIGHT(() -> FlightEffect.CODEC),
        WARP(() -> WarpEffect.CODEC),
        CURE(() -> CureEffect.CODEC),
        ATTRIBUTE(() -> AttributeModifierEffect.CODEC),
        GROWTICK(() -> GrowTickEffect.CODEC),
        TRINKETLOOT(() -> TrinketLootEffect.CODEC);

        private final Supplier<Codec<IEffectParameters>> codecSupplier;

        private EffectType(Supplier<Codec<IEffectParameters>> codecSupplier) {
            this.codecSupplier = codecSupplier;
        }

        public Supplier<Codec<IEffectParameters>> getCodecSupplier() {
            return this.codecSupplier;
        }
    }
}

