/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.compat;

import com.mcjty.fancytrinkets.compat.FancyJeiPlugin;
import com.mcjty.fancytrinkets.modules.xpcrafter.XpCrafterModule;
import com.mcjty.fancytrinkets.modules.xpcrafter.recipe.XpRecipe;
import mcjty.lib.varia.ComponentFactory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class XpRecipeCategory
implements IRecipeCategory<XpRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    public static final String KEY_XP_RECIPE_CATEGORY = "fancytrinkets.xp_recipe_category";

    public XpRecipeCategory(IGuiHelper guiHelper) {
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)XpCrafterModule.EXPERIENCE_CRAFTER.get()));
        this.background = guiHelper.createBlankDrawable(140, 120);
    }

    public RecipeType<XpRecipe> getRecipeType() {
        return FancyJeiPlugin.XP_RECIPE_TYPE;
    }

    public Component getTitle() {
        return ComponentFactory.translatable((String)KEY_XP_RECIPE_CATEGORY);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(XpRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                this.slot.draw(graphics, 4 + x * 18, 4 + y * 18);
            }
        }
        this.slot.draw(graphics, 112, 4);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, XpRecipe recipe, IFocusGroup focuses) {
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                builder.addSlot(RecipeIngredientRole.INPUT, 5 + x * 18, 5 + y * 18).addIngredients((Ingredient)recipe.m_7527_().get(y * 5 + x));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 5).addItemStack(recipe.getResultItem());
    }
}

