/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets;

import com.mcjty.fancytrinkets.curios.CuriosSetup;
import com.mcjty.fancytrinkets.datapack.CustomRegistries;
import com.mcjty.fancytrinkets.keys.KeyInputHandler;
import com.mcjty.fancytrinkets.modules.effects.EffectsModule;
import com.mcjty.fancytrinkets.modules.loot.LootModule;
import com.mcjty.fancytrinkets.modules.trinkets.TrinketsModule;
import com.mcjty.fancytrinkets.modules.xpcrafter.XpCrafterModule;
import com.mcjty.fancytrinkets.setup.ClientEventHandlers;
import com.mcjty.fancytrinkets.setup.Config;
import com.mcjty.fancytrinkets.setup.ModSetup;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="fancytrinkets")
public class FancyTrinkets {
    public static final String MODID = "fancytrinkets";
    public static FancyTrinkets instance;
    public static ModSetup setup;
    private final Modules modules = new Modules();

    public FancyTrinkets() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Dist dist = FMLEnvironment.dist;
        instance = this;
        Config.register();
        this.setupModules();
        Registration.register(bus);
        CustomRegistries.init(bus);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::onInterModEnqueueEvent);
        bus.addListener(this::onDataGen);
        bus.addListener(Config::onConfigLoading);
        bus.addListener(Config::onConfigReloading);
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
            bus.addListener(ClientEventHandlers::onRegisterKeyMappings);
            MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
            MinecraftForge.EVENT_BUS.addListener(ClientEventHandlers::onTooltip);
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen);
        setup.datagen(datagen);
        datagen.generate();
    }

    private void setupModules() {
        this.modules.register((IModule)new EffectsModule());
        this.modules.register((IModule)new TrinketsModule());
        this.modules.register((IModule)new XpCrafterModule());
        this.modules.register((IModule)new LootModule());
    }

    private void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        CuriosSetup.setupCurios();
    }

    static {
        setup = new ModSetup();
    }
}

