/*
 * Decompiled with CFR 0.152.
 */
package bogdan.deceased_expansion.mixin.lootr.furniture;

import bogdan.deceased_expansion.DeceasedMain;
import bogdan.deceased_expansion.access.IApocBlockEntityAccess;
import bogdan.deceased_expansion.access.IApocMenuAccess;
import bogdan.deceased_expansion.content.MixinOpenersCounter;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.util.ChestUtil;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BasicLootBlockEntity.class})
public abstract class BasicLootBlockEntityMixin
extends RandomizableContainerBlockEntity
implements ILootBlockEntity,
IApocBlockEntityAccess {
    @Unique
    public Set<UUID> openers = new HashSet<UUID>();
    @Unique
    private ResourceLocation dead$lootrLootTable;
    @Unique
    protected long dead$lootrSeed = -1L;
    @Unique
    private boolean savingToItem;
    @Unique
    private UUID tileId;
    @Shadow(remap=false)
    @Final
    protected ContainerOpenersCounter openersCounter;
    @Unique
    private ContainerOpenersCounter dead$openersCounter;

    protected BasicLootBlockEntityMixin(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void dead$initCounter(CallbackInfo ci) {
        this.dead$openersCounter = new MixinOpenersCounter(this.openersCounter){

            protected boolean m_142718_(Player player) {
                AbstractContainerMenu menu = player.f_36096_;
                Container inventory = null;
                if (menu instanceof ChestMenu) {
                    ChestMenu chestMenu = (ChestMenu)menu;
                    inventory = chestMenu.m_39261_();
                }
                if (menu instanceof IApocMenuAccess) {
                    IApocMenuAccess access = (IApocMenuAccess)menu;
                    inventory = access.dead$getContainer();
                }
                if (inventory != null && inventory instanceof SpecialChestInventory) {
                    SpecialChestInventory data = (SpecialChestInventory)inventory;
                    if (data.getTileId() == null) {
                        return data.getBlockEntity(BasicLootBlockEntityMixin.this.m_58904_()) == BasicLootBlockEntityMixin.this;
                    }
                    return data.getTileId().equals(BasicLootBlockEntityMixin.this.getTileId());
                }
                return false;
            }
        };
    }

    @Override
    public boolean dead$notifyBreak() {
        return this.dead$lootrLootTable != null;
    }

    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public void m_187476_(ItemStack itemstack) {
        this.savingToItem = true;
        super.m_187476_(itemstack);
        this.savingToItem = false;
    }

    public void m_59640_(@Nullable Player player) {
    }

    public void unpackLootTable(Player player, Container inventory, ResourceLocation overrideTable, long seed) {
        if (this.f_58857_ != null && this.dead$lootrLootTable != null && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_278653_().m_278676_(overrideTable != null ? overrideTable : this.dead$lootrLootTable);
            if (loottable == LootTable.f_79105_) {
                DeceasedMain.LOGGER.error("Unable to fill loot chest in {} at {} as the loot table '{}' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.", new Object[]{this.f_58857_.m_46472_().m_135782_(), this.f_58858_, overrideTable != null ? overrideTable : this.dead$lootrLootTable});
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue()) {
                    player.m_5661_(ChestUtil.getInvalidTable((ResourceLocation)(overrideTable != null ? overrideTable : this.dead$lootrLootTable)), false);
                }
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, overrideTable != null ? overrideTable : this.f_59605_);
            }
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (player != null) {
                builder.m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player);
            }
            loottable.m_287188_(inventory, builder.m_287235_(LootContextParamSets.f_81411_), LootrAPI.getLootSeed((long)(seed == Long.MIN_VALUE ? this.dead$lootrSeed : seed)));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.dead$lootrLootTable != null) {
            compound.m_128359_("LootTable", this.dead$lootrLootTable.toString());
            if (this.dead$lootrSeed != -1L) {
                compound.m_128356_("LootTableSeed", this.dead$lootrSeed);
            }
        }
        if (!LootrAPI.shouldDiscard() && !this.savingToItem) {
            compound.m_128362_("tileId", this.getTileId());
            ListTag list = new ListTag();
            for (UUID opener : this.openers) {
                list.add((Object)NbtUtils.m_129226_((UUID)opener));
            }
            compound.m_128365_("LootrOpeners", (Tag)list);
        }
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("specialLootChest_table", 8)) {
            this.dead$lootrLootTable = ResourceLocation.parse((String)compound.m_128461_("specialLootChest_table"));
        }
        if (compound.m_128425_("specialLootChest_seed", 4)) {
            this.dead$lootrSeed = compound.m_128454_("specialLootChest_seed");
        }
        if (this.dead$lootrLootTable == null && compound.m_128425_("LootTable", 8)) {
            this.dead$lootrLootTable = ResourceLocation.parse((String)compound.m_128461_("LootTable"));
            if (this.dead$lootrSeed == 0L && compound.m_128425_("LootTableSeed", 4)) {
                this.dead$lootrSeed = compound.m_128454_("LootTableSeed");
            }
        }
        if (this.dead$lootrLootTable == null && compound.m_128441_("deceased_lootr")) {
            CompoundTag deadTag = compound.m_128469_("deceased_lootr");
            this.dead$lootrLootTable = ResourceLocation.parse((String)deadTag.m_128461_("LootTable"));
            if (this.dead$lootrSeed == 0L && deadTag.m_128441_("LootTableSeed")) {
                this.dead$lootrSeed = deadTag.m_128454_("LootTableSeed");
            }
        }
        if (compound.m_128403_("tileId")) {
            this.tileId = compound.m_128342_("tileId");
        }
        if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.m_128441_("LootrOpeners")) {
            ListTag openers = compound.m_128437_("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.m_129233_((Tag)item));
            }
        }
        this.requestModelDataUpdate();
        super.m_142466_(compound);
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.dead$openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.dead$openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public ResourceLocation getTable() {
        return this.dead$lootrLootTable;
    }

    public BlockPos getPosition() {
        return this.m_58899_();
    }

    public long getSeed() {
        return this.dead$lootrSeed;
    }

    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void m_59626_(ResourceLocation lootTable, long seed) {
        this.dead$lootrLootTable = lootTable;
        this.dead$lootrSeed = seed;
        super.m_59626_(lootTable, seed);
    }

    protected void m_6520_(NonNullList<ItemStack> pItems) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    public void updatePacketViaState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 8);
        }
    }
}

