/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class FlatPortalAreaHelper
extends PortalFrameTester {
    protected int xSize = -1;
    protected int zSize = -1;
    protected final int maxXSize = 21;
    protected final int maxZSize = 21;

    @Override
    public FlatPortalAreaHelper init(LevelAccessor world, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        this.VALID_FRAME = Sets.newHashSet((Object[])foundations);
        this.world = world;
        this.lowerCorner = this.getLowerCorner(blockPos, Direction.Axis.X, Direction.Axis.Z);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.zSize = 1;
            this.xSize = 1;
        } else {
            this.xSize = this.getSize(Direction.Axis.X, 2, 21);
            if (this.xSize > 0) {
                this.zSize = this.getSize(Direction.Axis.Z, 2, 21);
                if (this.checkForValidFrame(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize)) {
                    this.countExistingPortalBlocks(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize);
                } else {
                    this.lowerCorner = null;
                    this.zSize = 1;
                    this.xSize = 1;
                }
            }
        }
        return this;
    }

    @Override
    public Optional<PortalFrameTester> getNewPortal(LevelAccessor worldAccess, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        return this.getOrEmpty(worldAccess, blockPos, areaHelper -> areaHelper.isValidFrame() && areaHelper.foundPortalBlocks == 0, axis, foundations);
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(LevelAccessor worldAccess, BlockPos blockPos, Predicate<PortalFrameTester> predicate, Direction.Axis axis, Block ... foundations) {
        return Optional.of(new FlatPortalAreaHelper().init(worldAccess, blockPos, axis, foundations)).filter(predicate);
    }

    @Override
    public boolean isAlreadyLitPortalFrame() {
        return this.isValidFrame() && this.foundPortalBlocks == this.xSize * this.zSize;
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.xSize >= 2 && this.zSize >= 2 && this.xSize < 21 && this.zSize < 21;
    }

    @Override
    public void lightPortal(Block frameBlock) {
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock);
        BlockState blockState = CustomPortalHelper.blockWithAxis(link != null ? link.getPortalBlock().m_49966_() : CustomPortalsMod.getDefaultPortalBlock().m_49966_(), Direction.Axis.Y);
        BlockPos.m_121940_((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.m_5487_(Direction.Axis.X, this.xSize - 1).m_5487_(Direction.Axis.Z, this.zSize - 1)).forEach(blockPos -> this.world.m_7731_(blockPos, blockState, 18));
    }

    @Override
    public void createPortal(Level world, BlockPos pos, BlockState frameBlock, Direction.Axis axis) {
        int i;
        for (i = -1; i < 3; ++i) {
            world.m_46597_(pos.m_5487_(Direction.Axis.X, i).m_5487_(Direction.Axis.Z, -1), frameBlock);
            world.m_46597_(pos.m_5487_(Direction.Axis.X, i).m_5487_(Direction.Axis.Z, 2), frameBlock);
            world.m_46597_(pos.m_5487_(Direction.Axis.Z, i).m_5487_(Direction.Axis.X, -1), frameBlock);
            world.m_46597_(pos.m_5487_(Direction.Axis.Z, i).m_5487_(Direction.Axis.X, 2), frameBlock);
        }
        for (i = 0; i < 2; ++i) {
            this.placeLandingPad(world, pos.m_5487_(Direction.Axis.X, i).m_7495_(), frameBlock);
            this.placeLandingPad(world, pos.m_5487_(Direction.Axis.X, i).m_5487_(Direction.Axis.Z, 1).m_7495_(), frameBlock);
            this.fillAirAroundPortal(world, pos.m_5487_(Direction.Axis.X, i).m_7494_());
            this.fillAirAroundPortal(world, pos.m_5487_(Direction.Axis.X, i).m_5487_(Direction.Axis.Z, 1).m_7494_());
            this.fillAirAroundPortal(world, pos.m_5487_(Direction.Axis.X, i).m_6630_(2));
            this.fillAirAroundPortal(world, pos.m_5487_(Direction.Axis.X, i).m_5487_(Direction.Axis.Z, 1).m_6630_(2));
        }
        this.lowerCorner = pos;
        this.zSize = 2;
        this.xSize = 2;
        this.world = world;
        this.foundPortalBlocks = 4;
        this.lightPortal(frameBlock.m_60734_());
    }

    protected void fillAirAroundPortal(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_280296_()) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 16);
        }
    }

    protected void placeLandingPad(Level world, BlockPos pos, BlockState frameBlock) {
        if (!world.m_8055_(pos).m_280296_()) {
            world.m_46597_(pos, frameBlock);
        }
    }

    @Override
    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return (this.xSize == attemptWidth || attemptHeight == 0) && this.zSize == attemptHeight || attemptWidth == 0 || (this.xSize == attemptHeight || attemptHeight == 0) && (this.zSize == attemptWidth || attemptWidth == 0);
    }

    @Override
    public BlockUtil.FoundRectangle getRectangle() {
        return new BlockUtil.FoundRectangle(this.lowerCorner, this.xSize, this.zSize);
    }

    @Override
    public Direction.Axis getAxis1() {
        return Direction.Axis.X;
    }

    @Override
    public Direction.Axis getAxis2() {
        return Direction.Axis.Z;
    }

    @Override
    public BlockPos doesPortalFitAt(Level world, BlockPos attemptPos, Direction.Axis axis) {
        BlockUtil.FoundRectangle rect = BlockUtil.m_124334_((BlockPos)attemptPos.m_7494_(), (Direction.Axis)Direction.Axis.X, (int)4, (Direction.Axis)Direction.Axis.Z, (int)4, blockPos -> world.m_8055_(blockPos).m_280296_() && !world.m_8055_(blockPos.m_7494_()).m_280296_() && !world.m_8055_(blockPos.m_7494_()).m_278721_() && !world.m_8055_(blockPos.m_6630_(2)).m_280296_() && !world.m_8055_(blockPos.m_6630_(2)).m_278721_());
        return rect.f_124349_ >= 4 && rect.f_124350_ >= 4 ? rect.f_124348_ : null;
    }

    @Override
    public Vec3 getEntityOffsetInPortal(BlockUtil.FoundRectangle arg, Entity entity, Direction.Axis portalAxis) {
        EntityDimensions entityDimensions = entity.m_6972_(entity.m_20089_());
        double xSize = (float)arg.f_124349_ - entityDimensions.f_20377_;
        double zSize = (float)arg.f_124350_ - entityDimensions.f_20377_;
        double deltaX = Mth.m_14112_((double)entity.m_20185_(), (double)arg.f_124348_.m_123341_(), (double)((double)arg.f_124348_.m_123341_() + xSize));
        double deltaY = Mth.m_14112_((double)entity.m_20186_(), (double)(arg.f_124348_.m_123342_() - 1), (double)(arg.f_124348_.m_123342_() + 1));
        double deltaZ = Mth.m_14112_((double)entity.m_20189_(), (double)arg.f_124348_.m_123343_(), (double)((double)arg.f_124348_.m_123343_() + zSize));
        return new Vec3(deltaX, deltaY, deltaZ);
    }

    @Override
    public PortalInfo getTPTargetInPortal(BlockUtil.FoundRectangle portalRect, Direction.Axis portalAxis, Vec3 prevOffset, Entity entity) {
        EntityDimensions entityDimensions = entity.m_6972_(entity.m_20089_());
        double xSize = (float)portalRect.f_124349_ - entityDimensions.f_20377_;
        double zSize = (float)portalRect.f_124350_ - entityDimensions.f_20377_;
        double x = Mth.m_14139_((double)prevOffset.f_82479_, (double)portalRect.f_124348_.m_123341_(), (double)((double)portalRect.f_124348_.m_123341_() + xSize));
        double y = Mth.m_14139_((double)prevOffset.f_82480_, (double)(portalRect.f_124348_.m_123342_() - 1), (double)(portalRect.f_124348_.m_123342_() + 1));
        double z = Mth.m_14139_((double)prevOffset.f_82481_, (double)portalRect.f_124348_.m_123343_(), (double)((double)portalRect.f_124348_.m_123343_() + zSize));
        y = Math.max(y, (double)portalRect.f_124348_.m_123342_());
        return new PortalInfo(new Vec3(x, y, z), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
    }
}

