/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal;

import java.util.HashSet;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class PortalIgnitionSource {
    public static final PortalIgnitionSource FIRE = new PortalIgnitionSource(SourceType.BLOCKPLACED, BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50083_));
    public static final PortalIgnitionSource WATER = PortalIgnitionSource.FluidSource((Fluid)Fluids.f_76193_);
    private static final HashSet<Item> USEITEMS = new HashSet();
    public SourceType sourceType;
    public ResourceLocation ignitionSourceID;

    private PortalIgnitionSource(SourceType sourceType, ResourceLocation ignitionSourceID) {
        this.sourceType = sourceType;
        this.ignitionSourceID = ignitionSourceID;
    }

    public static PortalIgnitionSource ItemUseSource(Item item) {
        USEITEMS.add(item);
        return new PortalIgnitionSource(SourceType.USEITEM, BuiltInRegistries.f_257033_.m_7981_((Object)item));
    }

    public static PortalIgnitionSource FluidSource(Fluid fluid) {
        return new PortalIgnitionSource(SourceType.FLUID, BuiltInRegistries.f_257020_.m_7981_((Object)fluid));
    }

    public static PortalIgnitionSource CustomSource(ResourceLocation ignitionSourceID) {
        return new PortalIgnitionSource(SourceType.CUSTOM, ignitionSourceID);
    }

    @Deprecated
    public void withCondition(BiFunction<Level, BlockPos, Boolean> condition) {
    }

    public boolean isWater() {
        return FluidTags.f_13131_.m_207645_(Registries.f_256808_);
    }

    public boolean isLava() {
        return FluidTags.f_13132_.m_207645_(Registries.f_256808_);
    }

    public static boolean isRegisteredIgnitionSourceWith(Item item) {
        return USEITEMS.contains(item);
    }

    public static enum SourceType {
        USEITEM,
        BLOCKPLACED,
        FLUID,
        CUSTOM;

    }
}

