/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi;

import java.util.Random;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.init.ParticleInit;
import net.kyrptonaught.customportalapi.interfaces.EntityInCustomPortal;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.CustomTeleporter;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    protected static final VoxelShape X_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Y_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public CustomPortalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.Z -> Z_SHAPE;
            case Direction.Axis.Y -> Y_SHAPE;
            default -> X_SHAPE;
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        PortalFrameTester portalFrameTester;
        Block block = this.getPortalBase((Level)world, pos);
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(block);
        if (link != null && (portalFrameTester = link.getFrameTester().createInstanceOfPortalFrameTester().init(world, pos, CustomPortalHelper.getAxisFrom(state), block)).isAlreadyLitPortalFrame()) {
            return super.m_7417_(state, direction, newState, world, pos, posFrom);
        }
        return Blocks.f_50016_.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void randomDisplayTick(BlockState state, Level world, BlockPos pos, Random random) {
        if (random.nextInt(100) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d = (double)pos.m_123341_() + random.nextDouble();
            double e = (double)pos.m_123342_() + random.nextDouble();
            double f = (double)pos.m_123343_() + random.nextDouble();
            double g = ((double)random.nextFloat() - 0.5) * 0.5;
            double h = ((double)random.nextFloat() - 0.5) * 0.5;
            double j = ((double)random.nextFloat() - 0.5) * 0.5;
            int k = random.nextInt(2) * 2 - 1;
            if (!world.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !world.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                d = (double)pos.m_123341_() + 0.5 + 0.25 * (double)k;
                g = random.nextFloat() * 2.0f * (float)k;
            } else {
                f = (double)pos.m_123343_() + 0.5 + 0.25 * (double)k;
                j = random.nextFloat() * 2.0f * (float)k;
            }
            world.m_7106_((ParticleOptions)new BlockParticleOption((ParticleType)ParticleInit.CUSTOMPORTALPARTICLE.get(), this.getPortalBase(world, pos).m_49966_()), d, e, f, g, h, j);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        EntityInCustomPortal entityInPortal = (EntityInCustomPortal)entity;
        entityInPortal.tickInPortal(pos.m_7949_());
        if (!entityInPortal.didTeleport() && entityInPortal.getTimeInPortal() >= entity.m_6078_()) {
            entityInPortal.setDidTP(true);
            if (!world.f_46443_) {
                CustomTeleporter.TPToDim(world, entity, this.getPortalBase(world, pos), pos);
            }
        }
    }

    public Block getPortalBase(Level world, BlockPos pos) {
        return CustomPortalHelper.getPortalBaseDefault(world, pos);
    }
}

